/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.DebugHelper;
import adams.core.Properties;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngineManager;
import java.util.Iterator;

public class ScriptingEngine
extends AbstractScriptingEngine {
    private static final long serialVersionUID = -2966869686762723507L;
    private static ScriptingEngineManager m_ScriptingEngineManager;
    private static Properties m_Properties;

    @Override
    protected int initDebugLevel() {
        return DebugHelper.getDebugLevel(ScriptingEngine.class);
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    @Override
    protected String getDefinitionKey() {
        return "scripting engine";
    }

    @Override
    protected synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = this.readProperties();
        }
        return m_Properties;
    }

    public static synchronized AbstractScriptingEngine getSingleton(AbstractDatabaseConnection dbcon) {
        if (m_ScriptingEngineManager == null) {
            m_ScriptingEngineManager = new ScriptingEngineManager();
        }
        if (!m_ScriptingEngineManager.has(dbcon)) {
            m_ScriptingEngineManager.add(dbcon, new ScriptingEngine());
            m_ScriptingEngineManager.get(dbcon).setDatabaseConnection(dbcon);
        }
        return m_ScriptingEngineManager.get(dbcon);
    }

    public static synchronized void stopAllEngines() {
        if (m_ScriptingEngineManager != null) {
            Iterator<AbstractScriptingEngine> iter = m_ScriptingEngineManager.iterator();
            while (iter.hasNext()) {
                iter.next().stopEngine();
            }
        }
    }
}

