/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFRelation;

public class XWPFPictureData
extends POIXMLDocumentPart {
    protected static final POIXMLRelation[] RELATIONS = new POIXMLRelation[8];

    protected XWPFPictureData() {
    }

    public XWPFPictureData(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public byte[] getData() {
        try {
            return IOUtils.toByteArray((InputStream)this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFileName() {
        String name = this.getPackagePart().getPartName().getName();
        if (name == null) {
            return null;
        }
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public String suggestFileExtension() {
        return this.getPackagePart().getPartName().getExtension();
    }

    public int getPictureType() {
        String contentType = this.getPackagePart().getContentType();
        for (int i = 0; i < RELATIONS.length; ++i) {
            if (RELATIONS[i] == null || !RELATIONS[i].getContentType().equals(contentType)) continue;
            return i;
        }
        return 0;
    }

    static {
        XWPFPictureData.RELATIONS[2] = XWPFRelation.IMAGE_EMF;
        XWPFPictureData.RELATIONS[3] = XWPFRelation.IMAGE_WMF;
        XWPFPictureData.RELATIONS[4] = XWPFRelation.IMAGE_PICT;
        XWPFPictureData.RELATIONS[5] = XWPFRelation.IMAGE_JPEG;
        XWPFPictureData.RELATIONS[6] = XWPFRelation.IMAGE_PNG;
        XWPFPictureData.RELATIONS[7] = XWPFRelation.IMAGE_DIB;
    }
}

