/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSNumber;
import java.awt.geom.Rectangle2D;

public class CDSRectangle
extends CDSBase {
    private static final float INCH_2_CM = 2.54f;
    private static final float A4_WIDTH = 21.0f;
    private static final float A4_HEIGHT = 29.7f;
    private static final float DPI = 72.0f;
    public static final float[] SIZE_A4 = new float[]{0.0f, 0.0f, 595.2756f, 841.88983f};
    private Rectangle2D cachedRectangle;
    private Rectangle2D cachedNormalizedRectangle;

    public static CDSRectangle createFromCOS(COSArray array) {
        if (array == null) {
            return null;
        }
        CDSRectangle rect = (CDSRectangle)array.getAttribute(CDSRectangle.class);
        if (rect == null) {
            rect = new CDSRectangle(array);
            array.setAttribute(CDSRectangle.class, rect);
        }
        return rect;
    }

    public CDSRectangle() {
        super(COSArray.createWith(0.0f, 0.0f, 0.0f, 0.0f));
    }

    protected CDSRectangle(COSArray newR) {
        super(newR);
    }

    public CDSRectangle(float llx, float lly, float urx, float ury) {
        super(COSArray.createWith(llx, lly, urx, ury));
    }

    public CDSRectangle(float[] rectArray) {
        this(rectArray[0], rectArray[1], rectArray[2], rectArray[3]);
    }

    public CDSRectangle(Rectangle2D rect) {
        super(COSArray.createWith((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY()));
    }

    public boolean contains(double x, double y) {
        float y1;
        float x1;
        COSArray array = this.cosGetArray();
        float x0 = ((COSNumber)array.get(0)).floatValue();
        if (x0 < (x1 = ((COSNumber)array.get(2)).floatValue()) ? x < (double)x0 || x > (double)x1 : x > (double)x0 || x < (double)x1) {
            return false;
        }
        float y0 = ((COSNumber)array.get(1)).floatValue();
        if (y0 < (y1 = ((COSNumber)array.get(3)).floatValue())) {
            return y >= (double)y0 && y <= (double)y1;
        }
        return y >= (double)y1 && y <= (double)y0;
    }

    public boolean contains(double x, double y, double epsilon) {
        float y1;
        float x1;
        COSArray array = this.cosGetArray();
        float x0 = ((COSNumber)array.get(0)).floatValue();
        if (x0 < (x1 = ((COSNumber)array.get(2)).floatValue()) ? x < (double)x0 - epsilon || x > (double)x1 + epsilon : x > (double)x0 + epsilon || x < (double)x1 - epsilon) {
            return false;
        }
        float y0 = ((COSNumber)array.get(1)).floatValue();
        if (y0 < (y1 = ((COSNumber)array.get(3)).floatValue())) {
            return y >= (double)y0 - epsilon && y <= (double)y1 + epsilon;
        }
        return y >= (double)y1 - epsilon && y <= (double)y0 + epsilon;
    }

    public CDSRectangle copy() {
        return new CDSRectangle((COSArray)this.cosGetArray().copyShallow());
    }

    public float getHeight() {
        return Math.abs(this.getUpperRightY() - this.getLowerLeftY());
    }

    public float getLowerLeftX() {
        return ((COSNumber)this.cosGetArray().get(0)).floatValue();
    }

    public float getLowerLeftY() {
        return ((COSNumber)this.cosGetArray().get(1)).floatValue();
    }

    public float getUpperRightX() {
        return ((COSNumber)this.cosGetArray().get(2)).floatValue();
    }

    public float getUpperRightY() {
        return ((COSNumber)this.cosGetArray().get(3)).floatValue();
    }

    public float getWidth() {
        return Math.abs(this.getUpperRightX() - this.getLowerLeftX());
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedNormalizedRectangle = null;
        this.cachedRectangle = null;
    }

    public void move(float dx, float dy) {
        this.setLowerLeftX(this.getLowerLeftX() + dx);
        this.setLowerLeftY(this.getLowerLeftY() + dy);
        this.setUpperRightX(this.getUpperRightX() + dx);
        this.setUpperRightY(this.getUpperRightY() + dy);
    }

    public CDSRectangle moveTo(float x, float y) {
        float width = this.getUpperRightX() - this.getLowerLeftX();
        float height = this.getUpperRightY() - this.getLowerLeftY();
        this.setLowerLeftX(x);
        this.setLowerLeftY(y);
        this.setUpperRightX(width + x);
        this.setUpperRightY(height + y);
        return this;
    }

    public CDSRectangle normalize() {
        float f;
        float f2;
        float f3;
        float f4;
        float t1 = this.getLowerLeftX();
        float t2 = this.getUpperRightX();
        if (f4 > f3) {
            this.setLowerLeftX(t2);
            this.setUpperRightX(t1);
        }
        t1 = this.getLowerLeftY();
        t2 = this.getUpperRightY();
        if (f2 > f) {
            this.setLowerLeftY(t2);
            this.setUpperRightY(t1);
        }
        return this;
    }

    public void resize(float dx, float dy) {
        this.setUpperRightX(this.getUpperRightX() + dx);
        this.setUpperRightY(this.getUpperRightY() + dy);
    }

    public void resizeTo(float width, float height) {
        this.setUpperRightX(this.getLowerLeftX() + width);
        this.setUpperRightY(this.getLowerLeftY() + height);
    }

    public void setCorners(float llx, float lly, float urx, float ury) {
        this.cosGetArray().set(0, COSFixed.create(llx));
        this.cosGetArray().set(1, COSFixed.create(lly));
        this.cosGetArray().set(2, COSFixed.create(urx));
        this.cosGetArray().set(3, COSFixed.create(ury));
    }

    public void setHeight(float height) {
        this.setUpperRightY(this.getLowerLeftY() + height);
    }

    public void setLowerLeftX(float num) {
        this.cosGetArray().set(0, COSFixed.create(num));
    }

    public void setLowerLeftY(float num) {
        this.cosGetArray().set(1, COSFixed.create(num));
    }

    public void setUpperRightX(float num) {
        this.cosGetArray().set(2, COSFixed.create(num));
    }

    public void setUpperRightY(float num) {
        this.cosGetArray().set(3, COSFixed.create(num));
    }

    public void setWidth(float width) {
        this.setUpperRightX(this.getLowerLeftX() + width);
    }

    public float[] toArray() {
        return new float[]{this.getLowerLeftX(), this.getLowerLeftY(), this.getUpperRightX(), this.getUpperRightY()};
    }

    public Rectangle2D toNormalizedRectangle() {
        if (this.cachedNormalizedRectangle == null) {
            float temp;
            float llx = this.getLowerLeftX();
            float lly = this.getLowerLeftY();
            float urx = this.getUpperRightX();
            float ury = this.getUpperRightY();
            if (llx > urx) {
                temp = llx;
                llx = urx;
                urx = temp;
            }
            if (lly > ury) {
                temp = lly;
                lly = ury;
                ury = temp;
            }
            this.cachedNormalizedRectangle = new Rectangle2D.Float(llx, lly, urx - llx, ury - lly);
        }
        return (Rectangle2D)this.cachedNormalizedRectangle.clone();
    }

    public Rectangle2D toRectangle() {
        if (this.cachedRectangle == null) {
            float llx = this.getLowerLeftX();
            float lly = this.getLowerLeftY();
            float urx = this.getUpperRightX();
            float ury = this.getUpperRightY();
            this.cachedRectangle = new Rectangle2D.Float(llx, lly, urx - llx, ury - lly);
        }
        return (Rectangle2D)this.cachedRectangle.clone();
    }
}

