/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.ArrayList;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;

public class Bootstrap
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -5084329826465538416L;
    private int count = 0;
    private Matrix selection = null;

    public Bootstrap(Matrix m) {
        this(m, (int)m.getRowCount());
    }

    public Bootstrap(Matrix m, int count) {
        super(m);
        this.count = count;
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        if (this.selection == null) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            int i = 0;
            while (i < this.count) {
                int s = MathUtil.nextInteger(0, (int)this.getSource().getRowCount() - 1);
                rows.add(s);
                ++i;
            }
            this.selection = this.getSource().selectRows(Calculation.Ret.LINK, rows);
        }
        return this.selection.getAsObject(coordinates);
    }

    public long[] getSize() {
        return new long[]{this.count, this.getSource().getColumnCount()};
    }
}

