/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusEvent;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RateLimitStatusListener;
import twitter4j.TwitterBase;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.http.OAuthSupport;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseCode;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.http.HttpResponseListener;

abstract class TwitterOAuthSupportBase
extends TwitterBase
implements HttpResponseCode,
HttpResponseListener,
OAuthSupport,
Serializable {
    private static final long serialVersionUID = 1918940571188204638L;
    protected transient HttpClientWrapper http;
    private List<RateLimitStatusListener> rateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);

    TwitterOAuthSupportBase(Configuration conf) {
        super(conf);
        this.init();
    }

    TwitterOAuthSupportBase(Configuration conf, String screenName, String password) {
        super(conf, screenName, password);
        this.init();
    }

    TwitterOAuthSupportBase(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.init();
    }

    private void init() {
        if (this.auth instanceof NullAuthorization) {
            String consumerKey = this.conf.getOAuthConsumerKey();
            String consumerSecret = this.conf.getOAuthConsumerSecret();
            if (null != consumerKey && null != consumerSecret) {
                OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
                String accessToken = this.conf.getOAuthAccessToken();
                String accessTokenSecret = this.conf.getOAuthAccessTokenSecret();
                if (null != accessToken && null != accessTokenSecret) {
                    oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
                }
                this.auth = oauth;
            }
        }
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    public void shutdown() {
        if (this.http != null) {
            this.http.shutdown();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<RateLimitStatusListener> serializableRateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
        Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
        while (i$.hasNext()) {
            RateLimitStatusListener listener = i$.next();
            if (!(listener instanceof Serializable)) continue;
            serializableRateLimitStatusListeners.add(listener);
        }
        out.writeObject(serializableRateLimitStatusListeners);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.rateLimitStatusListeners = (List)stream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    public abstract void setOAuthConsumer(String var1, String var2);

    public abstract RequestToken getOAuthRequestToken() throws TwitterException;

    public abstract RequestToken getOAuthRequestToken(String var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken() throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(String var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(RequestToken var1) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(RequestToken var1, String var2) throws TwitterException;

    public abstract void setOAuthAccessToken(AccessToken var1);

    public abstract AccessToken getOAuthAccessToken(String var1, String var2) throws TwitterException;

    public abstract AccessToken getOAuthAccessToken(String var1, String var2, String var3) throws TwitterException;

    public abstract void setOAuthAccessToken(String var1, String var2);

    public boolean isOAuthEnabled() {
        return this.auth instanceof OAuthAuthorization && this.auth.isEnabled();
    }

    public void setRateLimitStatusListener(RateLimitStatusListener listener) {
        this.rateLimitStatusListeners.clear();
        this.rateLimitStatusListeners.add(listener);
    }

    public void addRateLimitStatusListener(RateLimitStatusListener listener) {
        this.rateLimitStatusListeners.add(listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterOAuthSupportBase that = (TwitterOAuthSupportBase)o;
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return ((Object)this.rateLimitStatusListeners).equals(that.rateLimitStatusListeners);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + (this.rateLimitStatusListeners != null ? ((Object)this.rateLimitStatusListeners).hashCode() : 0);
        return result;
    }

    public void httpResponseReceived(HttpResponseEvent event) {
        block7: {
            int statusCode;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0) break block7;
            HttpResponse res = event.getResponse();
            TwitterException te = event.getTwitterException();
            if (null != te) {
                rateLimitStatus = te.getRateLimitStatus();
                statusCode = te.getStatusCode();
            } else {
                rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
                statusCode = res.getStatusCode();
            }
            if (null != rateLimitStatus) {
                RateLimitStatusEvent statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (statusCode == 420 || statusCode == 503) {
                    Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
                    while (i$.hasNext()) {
                        RateLimitStatusListener listener = i$.next();
                        listener.onRateLimitStatus(statusEvent);
                        listener.onRateLimitReached(statusEvent);
                    }
                } else {
                    Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
                    while (i$.hasNext()) {
                        RateLimitStatusListener listener = i$.next();
                        listener.onRateLimitStatus(statusEvent);
                    }
                }
            }
        }
    }
}

