/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Utils;
import java.io.Serializable;

public class ByteFormat
implements Serializable {
    private static final long serialVersionUID = -7848808006030837876L;
    protected String m_Format = null;
    protected boolean m_UseThousandSeparators = false;
    protected int m_NumDecimals = 0;
    protected Unit m_Unit = Unit.BYTES;
    protected boolean m_AddUnit = false;

    public ByteFormat(String format) {
        this.parseFormat(format);
    }

    protected void parseFormat(String format) {
        if (format == null) {
            return;
        }
        if (format.length() < 2) {
            return;
        }
        String s = format.substring(0, 1);
        if (!s.equals("b") && !s.equals("B")) {
            return;
        }
        boolean useSep = s.equals("B");
        int decimals = 0;
        s = format.substring(1, format.length());
        String decimalsStr = "";
        if (s.startsWith(".")) {
            s = s.substring(1);
            while (s.length() > 0 && s.charAt(0) >= '0' && s.charAt(0) <= '9') {
                decimalsStr = decimalsStr + s.charAt(0);
                s = s.substring(1);
            }
        }
        if (decimalsStr.length() > 0) {
            decimals = Integer.parseInt(decimalsStr);
        }
        if (s.length() != 1) {
            return;
        }
        boolean addUnit = s.equals(s.toUpperCase());
        Unit unit = Unit.parse(s);
        if (unit == null) {
            return;
        }
        this.m_Format = format;
        this.m_UseThousandSeparators = useSep;
        this.m_NumDecimals = decimals;
        this.m_Unit = unit;
        this.m_AddUnit = addUnit;
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String format(long bytes) {
        return this.format((double)bytes);
    }

    public String format(double bytes) {
        if (this.m_Format == null) {
            return "" + bytes;
        }
        double value = bytes / Math.pow(1024.0, this.m_Unit.getPower());
        String result = Utils.doubleToStringFixed(value, this.m_NumDecimals);
        if (this.m_AddUnit) {
            result = ByteFormat.insertThousandSeparators(result) + this.m_Unit.getUnit();
        }
        return result;
    }

    public String toString() {
        return "format=" + this.m_Format;
    }

    public static String insertThousandSeparators(String number) {
        if (number.indexOf(69) > -1) {
            return number.replace("E", "*10^");
        }
        int count = 0;
        int start = number.indexOf(46);
        if (start == -1) {
            start = number.length();
        }
        StringBuilder result = new StringBuilder(number.substring(start));
        for (int i = --start; i >= 0; --i) {
            if (i > 0 && count == 3) {
                result.insert(0, ",");
                count = 0;
            }
            result.insert(0, number.charAt(i));
            ++count;
        }
        return result.toString();
    }

    public static String toKiloBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "K").format(bytes);
    }

    public static String toMegaBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "M").format(bytes);
    }

    public static String toGigaBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "G").format(bytes);
    }

    public static String toTeraBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "T").format(bytes);
    }

    public static String toPetaBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "P").format(bytes);
    }

    public static String toExaBytes(double bytes, int decimals) {
        return new ByteFormat("B." + decimals + "E").format(bytes);
    }

    public static String toBestFitBytes(double bytes, int decimals) {
        double exp = Math.log(bytes) / Math.log(1024.0);
        if (exp >= 6.0) {
            return ByteFormat.toExaBytes(bytes, decimals);
        }
        if (exp >= 5.0) {
            return ByteFormat.toTeraBytes(bytes, decimals);
        }
        if (exp >= 4.0) {
            return ByteFormat.toTeraBytes(bytes, decimals);
        }
        if (exp >= 3.0) {
            return ByteFormat.toGigaBytes(bytes, decimals);
        }
        if (exp >= 2.0) {
            return ByteFormat.toMegaBytes(bytes, decimals);
        }
        if (exp >= 1.0) {
            return ByteFormat.toKiloBytes(bytes, decimals);
        }
        return bytes + "B";
    }

    public static enum Unit {
        BYTES(0, ""),
        KILO_BYTES(1, "KB"),
        MEGA_BYTES(2, "MB"),
        GIGA_BYTES(3, "GB"),
        TERA_BYTES(4, "TB"),
        PETA_BYTES(5, "PB"),
        EXA_BYTES(6, "EB");

        private int m_Power;
        private String m_Unit;

        private Unit(int power, String unit) {
            this.m_Power = power;
            this.m_Unit = unit;
        }

        public int getPower() {
            return this.m_Power;
        }

        public String getUnit() {
            return this.m_Unit;
        }

        public static Unit parse(String s) {
            if ((s = s.toLowerCase()).equals("k")) {
                return KILO_BYTES;
            }
            if (s.equals("m")) {
                return MEGA_BYTES;
            }
            if (s.equals("g")) {
                return GIGA_BYTES;
            }
            if (s.equals("t")) {
                return TERA_BYTES;
            }
            if (s.equals("p")) {
                return PETA_BYTES;
            }
            if (s.equals("e")) {
                return EXA_BYTES;
            }
            return null;
        }
    }
}

