/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.Conversion;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class NestedConsumer
extends AbstractRecursiveOptionConsumer<Vector, Vector> {
    private static final long serialVersionUID = 3076988578982973033L;

    @Override
    public String globalInfo() {
        return "Processes the nested format (tab indentation in string representation, nested Vector objects in object representation).";
    }

    protected int getIndentation(String s) {
        int result = 0;
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            ++result;
        }
        return result;
    }

    protected Vector linesToNested(Vector<String> lines, Vector<String> processed, int[] levels) {
        Vector<Object> result = new Vector<Object>();
        int level = levels[processed.size()];
        while (lines.size() > 0) {
            if (levels[processed.size()] == level) {
                result.add(lines.get(0).substring(level));
                processed.add(lines.get(0));
                lines.remove(0);
                continue;
            }
            if (levels[processed.size()] > level) {
                result.add(this.linesToNested(lines, processed, levels));
                continue;
            }
            if (levels[processed.size()] >= level) continue;
            break;
        }
        return result;
    }

    protected Vector linesToNested(Vector<String> lines) {
        int[] levels = new int[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            levels[i] = this.getIndentation(lines.get(i));
        }
        Vector result = this.linesToNested((Vector)lines.clone(), new Vector<String>(), levels);
        return result;
    }

    @Override
    protected OptionHandler initOutput() {
        OptionHandler result;
        try {
            result = (OptionHandler)Class.forName(Conversion.rename((String)((Vector)this.m_Input).get(0))).newInstance();
            ((Vector)this.m_Input).remove(0);
            this.m_Input = ((Vector)this.m_Input).size() > 0 ? (((Vector)this.m_Input).get(0) instanceof Vector ? (Vector)((Vector)this.m_Input).get(0) : new Vector()) : new Vector();
        }
        catch (Exception e) {
            String msg = "Failed to initialize output:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            result = null;
        }
        return result;
    }

    @Override
    protected Vector convertToInput(String s) {
        try {
            Vector<String> lines = new Vector<String>(Arrays.asList(s.split("\n")));
            while (lines.size() > 0 && lines.get(0).startsWith("#")) {
                lines.remove(0);
            }
            return this.linesToNested(lines);
        }
        catch (Exception e) {
            String msg = "Failed to convert to input:";
            this.logError(msg + " " + e);
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            return null;
        }
    }

    @Override
    protected void processOption(BooleanOption option, Vector values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        method.invoke((Object)option.getOptionHandler(), new Boolean(!option.isInvertingFlag()));
    }

    @Override
    protected void processOption(ClassOption option, Vector values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) instanceof String && Variables.isPlaceholder((String)values.get(i))) {
                option.setVariable((String)values.get(i));
                return;
            }
            Vector subset = (Vector)values.get(i);
            subset.set(0, Conversion.rename((String)subset.get(0)));
            Object object = Class.forName((String)subset.get(0)).newInstance();
            if (object instanceof OptionHandler) {
                NestedConsumer consumer = new NestedConsumer();
                consumer.setDebugLevel(this.getDebugLevel());
                consumer.setInput(subset);
                object = consumer.consume();
                this.m_Errors.addAll(consumer.getErrors());
                this.m_Warnings.addAll(consumer.getWarnings());
                consumer.cleanUp();
            } else {
                Vector optionsSet = subset.size() > 1 ? (Vector)subset.get(1) : new Vector();
                String[] options = optionsSet.toArray(new String[optionsSet.size()]);
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(object);
                handler.setOptions(object, options);
            }
            Array.set(objects, i, object);
            this.checkDeprecation(object);
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    @Override
    protected void processOption(AbstractArgumentOption option, Vector values) throws Exception {
        Method method = this.getWriteMethod(option);
        if (method == null) {
            return;
        }
        Object objects = Array.newInstance(option.getBaseClass(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (Variables.isPlaceholder((String)values.get(i))) {
                option.setVariable((String)values.get(i));
                return;
            }
            Array.set(objects, i, option.valueOf((String)values.get(i)));
            if (!option.isMultiple()) break;
        }
        if (!option.isMultiple()) {
            method.invoke((Object)option.getOptionHandler(), Array.get(objects, 0));
        } else {
            method.invoke((Object)option.getOptionHandler(), objects);
        }
    }

    protected Vector collectValues(AbstractOption option, Vector input) {
        Vector result = new Vector();
        boolean hasArg = option instanceof AbstractArgumentOption;
        int i = 0;
        String optionStr = this.getOptionIdentifier(option);
        while (i < input.size()) {
            if (input.get(i) instanceof String) {
                if (input.get(i).equals(optionStr)) {
                    input.remove(i);
                    if (!hasArg || i >= input.size()) continue;
                    result.add(input.get(i));
                    input.remove(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void doConsume(OptionManager manager, Vector input) {
        int i = 0;
        while (i < input.size()) {
            String msg;
            if (!(input.get(i) instanceof String)) {
                ++i;
                continue;
            }
            String cmdline = (String)input.get(i);
            if (cmdline.length() == 0) {
                ++i;
                continue;
            }
            if (!cmdline.startsWith("-")) continue;
            cmdline = cmdline.substring(1);
            AbstractOption option = manager.findByFlag(cmdline);
            Vector values = null;
            if (option == null) {
                msg = "Failed to find option (" + manager.getOwner().getClass().getName() + "): " + cmdline;
                this.logWarning(msg);
                this.getSystemErr().println(msg);
                input.remove(i);
                if (i < input.size() && input.get(i) instanceof String) {
                    if (((String)input.get(i)).startsWith("-")) continue;
                    input.remove(i);
                    continue;
                }
                if (i >= input.size()) continue;
                input.remove(i);
                continue;
            }
            if (option instanceof AbstractArgumentOption) {
                values = this.collectValues(option, input);
                if (values.size() == 0) {
                    msg = "No argument supplied for option '" + option + "' (" + manager.getOwner().getClass().getName() + ")!";
                    this.logWarning(msg);
                    this.getSystemErr().println(msg);
                }
            } else if (option instanceof BooleanOption) {
                this.collectValues(option, input);
            }
            try {
                this.processOption(option, values);
            }
            catch (Exception e) {
                msg = "Failed to process option '" + this.getOptionIdentifier(option) + "':";
                this.logError(msg + " " + e);
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
        }
    }
}

