/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.test.AbstractCondition;
import adams.flow.condition.test.True;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;

public abstract class AbstractConditionalActor
extends AbstractActor
implements ActorHandler {
    private static final long serialVersionUID = -7877511203822332577L;
    protected AbstractCondition m_Condition;
    protected AbstractActor m_BaseActor;
    protected boolean m_CheckAtExecutionTime;
    protected boolean m_ExecuteOnFail;
    protected boolean m_BaseActorInitialized;

    @Override
    public String globalInfo() {
        return "Singleton that takes a condition.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new True());
        this.m_OptionManager.add("execution-time", "checkAtExecutionTime", false);
        this.m_OptionManager.add("execute-on-fail", "executeOnFail", false);
        this.m_OptionManager.add("actor", "actor", this.getDefaultActor());
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("condition");
        if (variable != null) {
            return variable;
        }
        if (this.m_Condition != null) {
            return this.m_Condition.getClass().getName();
        }
        return null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_BaseActorInitialized = false;
    }

    public void setCondition(AbstractCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    public AbstractCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition that has to be met before the actor can be executed.";
    }

    public void setCheckAtExecutionTime(boolean value) {
        this.m_CheckAtExecutionTime = value;
        this.reset();
    }

    public boolean getCheckAtExecutionTime() {
        return this.m_CheckAtExecutionTime;
    }

    public String checkAtExecutionTimeTipText() {
        return "If set to true, then the condition is checked at execution time (whenever the actor gets executed) and not during setup.";
    }

    public void setExecuteOnFail(boolean value) {
        this.m_ExecuteOnFail = value;
        this.reset();
    }

    public boolean getExecuteOnFail() {
        return this.m_ExecuteOnFail;
    }

    public String executeOnFailTipText() {
        return "If set to true, then the actor is only executed if the condition fails.";
    }

    protected abstract AbstractActor getDefaultActor();

    public void setActor(AbstractActor value) {
        this.m_BaseActor = value;
        this.updateParent();
        this.reset();
    }

    public AbstractActor getActor() {
        return this.m_BaseActor;
    }

    public abstract String actorTipText();

    @Override
    public String check() {
        return this.m_BaseActor.setUp();
    }

    protected void updateParent() {
        if (this.m_BaseActor != null) {
            this.m_BaseActor.setParent(this);
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_BaseActor;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index != 0) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        this.m_BaseActor = actor;
        this.updateParent();
    }

    @Override
    public int indexOf(String actor) {
        if (actor.equals(this.m_BaseActor.getName())) {
            return 0;
        }
        return -1;
    }

    @Override
    public AbstractActor firstActive() {
        if (this.m_BaseActor.getSkip()) {
            return null;
        }
        return this.m_BaseActor;
    }

    @Override
    public AbstractActor lastActive() {
        if (this.m_BaseActor.getSkip()) {
            return null;
        }
        return this.m_BaseActor;
    }

    @Override
    protected boolean canInspectOptions(Class cls) {
        if (cls == AbstractActor[].class) {
            return false;
        }
        if (cls == AbstractActor.class) {
            return false;
        }
        return super.canInspectOptions(cls);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (!this.m_CheckAtExecutionTime) {
                result = this.m_Condition.getTestResult();
                if (this.m_ExecuteOnFail) {
                    result = null;
                }
            }
            this.m_BaseActorInitialized = false;
        }
        return result;
    }

    @Override
    protected String preExecute() {
        String result = super.preExecute();
        if (result == null) {
            if (this.m_CheckAtExecutionTime) {
                result = this.m_Condition.getTestResult();
            }
            if (this.m_ExecuteOnFail) {
                result = null;
            }
            if (result == null && !this.m_BaseActorInitialized) {
                result = this.m_BaseActor.setUp();
                this.m_BaseActorInitialized = result == null;
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        boolean execute = true;
        if (this.m_ExecuteOnFail) {
            boolean bl = execute = this.m_Condition.getTestResult() != null;
        }
        if (execute) {
            result = this.m_BaseActor.execute();
        }
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_BaseActor.cleanUp();
    }
}

