/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.base.BaseString;
import adams.core.option.DebugNestedProducer;
import adams.flow.control.Flow;
import adams.flow.core.ActorUtils;
import adams.flow.core.ControlActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.dialog.TextDialog;
import adams.gui.flow.StoragePanel;
import adams.gui.tools.ExpressionWatchPanel;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.debug.InspectionPanel;
import adams.parser.BooleanExpression;
import adams.parser.BooleanExpressionText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Breakpoint
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = 1670185555433805533L;
    protected BooleanExpressionText m_Expression;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;
    protected int m_X;
    protected int m_Y;
    protected BasePanel m_Panel;
    protected BaseFrame m_Frame;
    protected boolean m_Disabled;
    protected transient Token m_CurrentToken;
    protected Dialog[] m_Dialogs;

    @Override
    public String globalInfo() {
        return "Allows to pause the execution of the flow when this actor is reached and the condition evaluates to 'true'.\nIt is possible to define watches as well.\n\nThe expression has the following underlying grammar:\n" + new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "x", this.getDefaultX(), -3, null);
        this.m_OptionManager.add("y", "y", this.getDefaultY(), -3, null);
        this.m_OptionManager.add("expression", "expression", new BooleanExpressionText("true"));
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("dialog", "dialogs", new Dialog[0]);
    }

    @Override
    public String getQuickInfo() {
        String result = "";
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            result = variable;
        } else if (this.m_Expression != null && this.m_Expression.getValue().length() > 0) {
            result = this.m_Expression.stringValue();
        }
        if (this.m_Watches.length > 0) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + this.m_Watches.length + " watch";
            if (this.m_Watches.length > 1) {
                result = result + "es";
            }
        }
        if (this.m_Dialogs.length > 0) {
            result = result + ", dialog";
            if (this.m_Dialogs.length > 1) {
                result = result + "s";
            }
            result = result + ": ";
            for (int i = 0; i < this.m_Dialogs.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + (Object)((Object)this.m_Dialogs[i]);
            }
        }
        return result;
    }

    protected int getDefaultX() {
        return -3;
    }

    protected int getDefaultY() {
        return -1;
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the dialog (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the dialog (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    public void setExpression(BooleanExpressionText value) {
        if (Variables.isPlaceholder(value.getValue())) {
            value = new BooleanExpressionText("(" + value.getValue() + ")");
        }
        this.m_Expression = value;
        this.reset();
    }

    public BooleanExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to evaluate; if the expression evaluates to 'true', the execution of the flow is paused and a control window is opened.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setDialogs(Dialog[] value) {
        this.m_Dialogs = value;
        this.reset();
    }

    public Dialog[] getDialogs() {
        return this.m_Dialogs;
    }

    public String dialogsTipText() {
        return "The dialogs to display automatically when the breakpoint is reached.";
    }

    protected BasePanel newPanel() {
        ControlPanel result = new ControlPanel();
        for (int i = 0; i < this.m_Watches.length; ++i) {
            result.addWatch(this.m_Watches[i].getValue(), this.m_WatchTypes[i]);
        }
        return result;
    }

    protected boolean evalCondition(Token input) {
        boolean result;
        String exp = this.getVariables().expand(this.m_Expression.getValue());
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        if (input.getPayload() instanceof Integer) {
            symbols.put("X", ((Integer)input.getPayload()).doubleValue());
        } else if (input.getPayload() instanceof Double) {
            symbols.put("X", (Double)input.getPayload());
        }
        try {
            result = BooleanExpression.evaluate(exp, symbols);
            if (this.getDebugLevel() >= 2) {
                this.debug("exp: " + this.m_Expression + "\n" + "  --> " + exp + "\n" + "  = " + result, 2);
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Error evaluating boolean expression: " + exp);
            this.getSystemErr().printStackTrace(e);
            this.m_Expression = new BooleanExpressionText("true");
            this.getSystemErr().println("Reseting expression to: " + this.m_Expression);
            if (this.m_Panel != null) {
                ((ControlPanel)this.m_Panel).updateExpression();
            }
            result = false;
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Watches.length != this.m_WatchTypes.length) {
            Utils.adjustArray(this.m_WatchTypes, this.m_Watches.length, (Object)ExpressionWatchPanel.ExpressionType.STRING);
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected void setDisabled(boolean value) {
        this.m_Disabled = value;
    }

    protected boolean isDisabled() {
        return this.m_Disabled;
    }

    protected BaseFrame createFrame(BasePanel panel) {
        BaseFrame result = new BaseFrame(this.getName());
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        result.setDefaultCloseOperation(1);
        ImageIcon icon = GUIHelper.getIcon(this.getClass());
        if (icon != null) {
            result.setIconImage(icon.getImage());
        } else {
            result.setIconImage(GUIHelper.getIcon("flow.gif").getImage());
        }
        if (panel instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)panel)).getMenuBar());
        } else if (this instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)this)).getMenuBar());
        }
        result.setLocation(ActorUtils.determineLocation(result, this.m_X, this.m_Y));
        result.pack();
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_CurrentToken = this.m_InputToken;
        if (!this.isHeadless() && !this.isDisabled()) {
            if (this.evalCondition(this.m_CurrentToken)) {
                ((Flow)this.getRoot()).pauseExecution();
            }
            if (this.m_Panel == null) {
                this.m_Panel = this.newPanel();
                this.m_Frame = this.createFrame(this.m_Panel);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (!Breakpoint.this.m_Frame.isVisible()) {
                        Breakpoint.this.m_Frame.setVisible(true);
                    }
                    ((ControlPanel)Breakpoint.this.m_Panel).breakpointReached();
                }
            };
            SwingUtilities.invokeLater(run);
        }
        this.m_OutputToken = this.m_CurrentToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void stopExecution() {
        if (this.m_Frame != null && this.m_Frame.isVisible()) {
            this.m_Frame.setVisible(false);
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        this.m_CurrentToken = null;
        this.doCleanUpGUI();
        super.wrapUp();
    }

    protected void cleanUpGUI() {
        if (this.m_Frame != null) {
            if (this.m_Panel instanceof CleanUpHandler) {
                ((CleanUpHandler)((Object)this.m_Panel)).cleanUp();
            }
            this.m_Frame.setVisible(false);
            this.m_Frame.dispose();
            this.m_Frame = null;
            this.m_Panel = null;
        }
    }

    protected void doCleanUpGUI() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Breakpoint.this.cleanUpGUI();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void cleanUp() {
        this.doCleanUpGUI();
        super.cleanUp();
    }

    public static enum Dialog {
        SOURCE,
        EXPRESSIONS,
        VARIABLES,
        STORAGE,
        INSPECT_TOKEN,
        INSPECT_FLOW;

    }

    public class ControlPanel
    extends BasePanel
    implements CleanUpHandler {
        private static final long serialVersionUID = 1000900663466801934L;
        protected JButton m_ButtonContinue;
        protected JButton m_ButtonStop;
        protected JButton m_ButtonDisableEnable;
        protected JButton m_ButtonExpressions;
        protected BaseDialog m_DialogExpressions;
        protected JTextField m_TextBreakpointExpression;
        protected JButton m_ButtonBreakpointExpressionUpdate;
        protected JButton m_ButtonSource;
        protected JButton m_ButtonVariables;
        protected JButton m_ButtonStorage;
        protected JButton m_ButtonInspectToken;
        protected JButton m_ButtonInspectFlow;
        protected ExpressionWatchPanel m_PanelExpressions;
        protected VariableManagementPanel m_PanelVariables;
        protected InspectionPanel m_PanelInspectionToken;
        protected InspectionPanel m_PanelInspectionFlow;
        protected StoragePanel m_PanelStorage;
        protected TextDialog m_DialogSource;

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            JPanel panelAllButtons = new JPanel(new BorderLayout());
            this.add((Component)panelAllButtons, "Center");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Execution"));
            panelAllButtons.add((Component)panel, "North");
            JPanel panelButtons = new JPanel(new GridLayout(2, 2));
            panel.add((Component)panelButtons, "North");
            this.m_ButtonContinue = new JButton("Continue", GUIHelper.getIcon("run.gif"));
            this.m_ButtonContinue.setMnemonic('C');
            this.m_ButtonContinue.setToolTipText("Continues with the flow execution");
            this.m_ButtonContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.continueFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonContinue);
            this.m_ButtonStop = new JButton("Stop", GUIHelper.getIcon("stop.gif"));
            this.m_ButtonStop.setMnemonic('S');
            this.m_ButtonStop.setToolTipText("Stops the flow execution immediately");
            this.m_ButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.stopFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonStop);
            this.m_ButtonDisableEnable = new JButton("Disable", GUIHelper.getIcon("debug_off.png"));
            this.m_ButtonDisableEnable.setMnemonic('D');
            this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
            this.m_ButtonDisableEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.disableEnableBreakpoint();
                }
            });
            panelButtons.add(this.m_ButtonDisableEnable);
            JPanel panelCondition = new JPanel(new FlowLayout(0));
            panel.add((Component)panelCondition, "Center");
            this.m_TextBreakpointExpression = new JTextField(10);
            this.m_TextBreakpointExpression.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ControlPanel.this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ControlPanel.this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ControlPanel.this.update();
                }
            });
            this.m_ButtonBreakpointExpressionUpdate = new JButton("Update");
            this.m_ButtonBreakpointExpressionUpdate.setToolTipText("Update the breakpoint condition");
            this.m_ButtonBreakpointExpressionUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.updateExpression();
                }
            });
            panelCondition.add(new JLabel("Condition"));
            panelCondition.add(this.m_TextBreakpointExpression);
            panelCondition.add(this.m_ButtonBreakpointExpressionUpdate);
            panelButtons = new JPanel(new GridLayout(3, 2));
            panelButtons.setBorder(BorderFactory.createTitledBorder("Runtime information"));
            panelAllButtons.add((Component)panelButtons, "Center");
            this.m_ButtonSource = new JButton("Source", GUIHelper.getIcon("source.png"));
            this.m_ButtonSource.setMnemonic('o');
            this.m_ButtonSource.setToolTipText("Display current flow state as source (nested format)");
            this.m_ButtonSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showSource();
                }
            });
            panelButtons.add(this.m_ButtonSource);
            this.m_ButtonExpressions = new JButton("Expressions", GUIHelper.getIcon("glasses.gif"));
            this.m_ButtonExpressions.setMnemonic('x');
            this.m_ButtonExpressions.setToolTipText("Display dialog for watch expressions");
            this.m_ButtonExpressions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showWatchExpressions();
                }
            });
            panelButtons.add(this.m_ButtonExpressions);
            this.m_ButtonVariables = new JButton("Variables", GUIHelper.getIcon("variable.gif"));
            this.m_ButtonVariables.setMnemonic('V');
            this.m_ButtonVariables.setToolTipText("Display dialog with currently active variables");
            this.m_ButtonVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showVariables();
                }
            });
            panelButtons.add(this.m_ButtonVariables);
            this.m_ButtonStorage = new JButton("Storage", GUIHelper.getIcon("disk.png"));
            this.m_ButtonStorage.setMnemonic('t');
            this.m_ButtonStorage.setToolTipText("Display dialog with items currently stored in temporary storage");
            this.m_ButtonStorage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showStorage();
                }
            });
            panelButtons.add(this.m_ButtonStorage);
            this.m_ButtonInspectToken = new JButton("Inspect token", GUIHelper.getIcon("properties.gif"));
            this.m_ButtonInspectToken.setMnemonic('I');
            this.m_ButtonInspectToken.setToolTipText("Display dialog for inspecting the current token");
            this.m_ButtonInspectToken.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectToken();
                }
            });
            panelButtons.add(this.m_ButtonInspectToken);
            this.m_ButtonInspectFlow = new JButton("Inspect flow", GUIHelper.getIcon("flow.gif"));
            this.m_ButtonInspectFlow.setMnemonic('n');
            this.m_ButtonInspectFlow.setToolTipText("Display dialog for inspecting the current flow");
            this.m_ButtonInspectFlow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectFlow();
                }
            });
            panelButtons.add(this.m_ButtonInspectFlow);
            this.m_PanelExpressions = new ExpressionWatchPanel();
        }

        protected Flow getFlow() {
            return (Flow)Breakpoint.this.getRoot();
        }

        protected void update() {
            Flow flow = this.getFlow();
            this.m_ButtonContinue.setEnabled(flow.isPaused());
            this.m_ButtonStop.setEnabled(!flow.isStopped());
            this.m_ButtonDisableEnable.setEnabled(!flow.isStopped());
            this.m_ButtonExpressions.setEnabled(flow.isPaused());
            this.m_ButtonBreakpointExpressionUpdate.setEnabled(this.m_TextBreakpointExpression.getText().length() > 0);
        }

        protected void continueFlowExecution() {
            if (!this.m_TextBreakpointExpression.getText().equals(Breakpoint.this.getExpression())) {
                Breakpoint.this.m_Expression = new BooleanExpressionText(this.m_TextBreakpointExpression.getText());
            }
            this.getFlow().resumeExecution();
            this.update();
        }

        protected void stopFlowExecution() {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(false);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ControlPanel.this.getFlow().stopExecution("User stopped flow!");
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void disableEnableBreakpoint() {
            Breakpoint.this.setDisabled(!Breakpoint.this.isDisabled());
            if (Breakpoint.this.isDisabled()) {
                this.m_ButtonDisableEnable.setText("Enable");
                this.m_ButtonDisableEnable.setMnemonic('E');
                this.m_ButtonDisableEnable.setToolTipText("Enable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug.png"));
            } else {
                this.m_ButtonDisableEnable.setText("Disable");
                this.m_ButtonDisableEnable.setMnemonic('D');
                this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug_off.png"));
            }
            Flow flow = this.getFlow();
            if (flow.isPaused()) {
                flow.resumeExecution();
            }
            this.update();
        }

        protected void showWatchExpressions() {
            if (this.m_DialogExpressions == null) {
                this.m_PanelExpressions.setVariables(Breakpoint.this.getVariables());
                this.m_DialogExpressions = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
                this.m_DialogExpressions.setTitle("Expression watch");
                this.m_DialogExpressions.setSize(600, 400);
                this.m_DialogExpressions.getContentPane().setLayout(new BorderLayout());
                this.m_DialogExpressions.getContentPane().add((Component)this.m_PanelExpressions, "Center");
                this.m_DialogExpressions.pack();
                this.m_DialogExpressions.setLocationRelativeTo(null);
            }
            this.m_DialogExpressions.setVisible(true);
        }

        protected void showSource() {
            DebugNestedProducer producer = new DebugNestedProducer();
            producer.produce(this.getFlow());
            String content = producer.toString();
            producer.cleanUp();
            if (this.m_DialogSource == null) {
                this.m_DialogSource = this.getParentDialog() != null ? new TextDialog(this.getParentDialog()) : new TextDialog(this.getParentFrame());
                this.m_DialogSource.setTitle("Current state");
                this.m_DialogSource.setEditable(false);
                this.m_DialogSource.setTabSize(2);
                this.m_DialogSource.setLocationRelativeTo(null);
            }
            this.m_DialogSource.setContent(content);
            this.m_DialogSource.setVisible(true);
        }

        protected void showVariables() {
            if (this.m_PanelVariables == null) {
                this.m_PanelVariables = new VariableManagementPanel();
                this.m_PanelVariables.setVariables(Breakpoint.this.getVariables());
                BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
                dialog.setTitle("Variables");
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)this.m_PanelVariables, "Center");
                dialog.pack();
                dialog.setLocationRelativeTo(null);
            }
            this.m_PanelVariables.getParentDialog().setVisible(true);
        }

        protected void inspectToken() {
            if (this.m_PanelInspectionToken == null) {
                this.m_PanelInspectionToken = new InspectionPanel();
                BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
                dialog.setTitle("Current token");
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)this.m_PanelInspectionToken, "Center");
                dialog.setJMenuBar(this.m_PanelInspectionToken.getMenuBar());
                dialog.setSize(800, 500);
                dialog.setLocationRelativeTo(null);
            }
            this.m_PanelInspectionToken.setCurrent(Breakpoint.this.m_CurrentToken);
            this.m_PanelInspectionToken.getParentDialog().setVisible(true);
        }

        protected void inspectFlow() {
            if (this.m_PanelInspectionFlow == null) {
                this.m_PanelInspectionFlow = new InspectionPanel();
                BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
                dialog.setTitle("Current flow");
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)this.m_PanelInspectionFlow, "Center");
                dialog.setJMenuBar(this.m_PanelInspectionFlow.getMenuBar());
                dialog.setSize(800, 500);
                dialog.setLocationRelativeTo(null);
            }
            this.m_PanelInspectionFlow.setCurrent(Breakpoint.this.m_Self.getRoot());
            this.m_PanelInspectionFlow.getParentDialog().setVisible(true);
        }

        protected void showStorage() {
            if (this.m_PanelStorage == null) {
                this.m_PanelStorage = new StoragePanel();
                BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
                dialog.setTitle("Temporary storage");
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)this.m_PanelStorage, "Center");
                dialog.pack();
                dialog.setLocationRelativeTo(null);
            }
            this.m_PanelStorage.setHandler(Breakpoint.this.getStorageHandler());
            this.m_PanelStorage.getParentDialog().setVisible(true);
        }

        public void breakpointReached() {
            this.m_PanelExpressions.refreshAllExpressions();
            this.m_TextBreakpointExpression.setText(Breakpoint.this.getExpression().getValue());
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken.setCurrent(Breakpoint.this.m_CurrentToken);
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.setHandler(Breakpoint.this.getStorageHandler());
            }
            this.update();
            block7: for (Dialog d : Breakpoint.this.m_Dialogs) {
                switch (d) {
                    case SOURCE: {
                        this.showSource();
                        continue block7;
                    }
                    case EXPRESSIONS: {
                        this.showWatchExpressions();
                        continue block7;
                    }
                    case INSPECT_TOKEN: {
                        this.inspectToken();
                        continue block7;
                    }
                    case STORAGE: {
                        this.showStorage();
                        continue block7;
                    }
                    case VARIABLES: {
                        this.showVariables();
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled dialog type: " + (Object)((Object)d));
                    }
                }
            }
        }

        public void updateExpression() {
            Breakpoint.this.setExpression(new BooleanExpressionText(this.m_TextBreakpointExpression.getText()));
        }

        public void addWatch(String expr, ExpressionWatchPanel.ExpressionType type) {
            this.m_PanelExpressions.addExpression(expr, type);
        }

        @Override
        public void cleanUp() {
            if (this.m_DialogSource != null) {
                this.m_DialogSource.dispose();
                this.m_DialogSource = null;
            }
            if (this.m_PanelExpressions != null) {
                this.m_PanelExpressions.closeParent();
                this.m_PanelExpressions = null;
                this.m_DialogExpressions = null;
            }
            if (this.m_PanelVariables != null) {
                this.m_PanelVariables.closeParent();
                this.m_PanelVariables = null;
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.cleanUp();
                this.m_PanelStorage.closeParent();
                this.m_PanelStorage = null;
            }
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken.closeParent();
                this.m_PanelInspectionToken = null;
            }
            if (this.m_PanelInspectionFlow != null) {
                this.m_PanelInspectionFlow.closeParent();
                this.m_PanelInspectionFlow = null;
            }
        }
    }
}

