/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.flow.container.SequencePlotterContainer;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractPlotUpdater;

public class SimplePlotUpdater
extends AbstractPlotUpdater {
    private static final long serialVersionUID = 4418135588639219439L;
    protected int m_UpdateInterval;
    protected int m_NumTokensAccepted;

    @Override
    public String globalInfo() {
        return "Updates the flow after the specified number of tokens have been processed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-interval", "updateInterval", 1, 1, null);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_NumTokensAccepted = 0;
    }

    public void setUpdateInterval(int value) {
        if (value >= 1) {
            this.m_UpdateInterval = value;
            this.reset();
        } else {
            this.getSystemErr().println("Update interval must be >= 1, provided: " + value);
        }
    }

    public int getUpdateInterval() {
        return this.m_UpdateInterval;
    }

    public String updateIntervalTipText() {
        return "Specifies the number of tokens after which the display is being updated (markers excluded).";
    }

    @Override
    protected boolean canNotify(SequencePlotter plotter, SequencePlotterContainer cont) {
        boolean isMarker = (Boolean)cont.getValue("IsMarker");
        if (!isMarker) {
            ++this.m_NumTokensAccepted;
        }
        return this.m_NumTokensAccepted % this.m_UpdateInterval == 0;
    }
}

