/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.OptionHandler;
import adams.gui.core.BaseTree;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import adams.gui.visualization.debug.objecttree.Node;
import adams.gui.visualization.debug.objecttree.Renderer;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;

public class Tree
extends BaseTree {
    private static final long serialVersionUID = -127345486742553561L;
    protected Tree m_Self = this;
    protected transient Object m_Object;
    protected Vector<AbstractInspectionHandler> m_Handlers;
    protected HashSet<Object> m_Inspected;

    public Tree() {
        this.setShowsRootHandles(true);
        this.setRootVisible(true);
        this.setCellRenderer(new Renderer());
        this.initHandlers();
        this.buildTree(null);
    }

    protected void initHandlers() {
        String[] handlers = AbstractInspectionHandler.getHandlers();
        this.m_Handlers = new Vector();
        for (String handler : handlers) {
            try {
                this.m_Handlers.add((AbstractInspectionHandler)Class.forName(handler).newInstance());
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection handler '" + handler + "':");
                e.printStackTrace();
            }
        }
    }

    protected void buildTree(Object root) {
        DefaultTreeModel model;
        this.m_Inspected = new HashSet();
        if (root == null) {
            model = new DefaultTreeModel(null);
        } else {
            Node rootNode = this.buildTree(null, null, root, false);
            model = new DefaultTreeModel(rootNode);
        }
        this.m_Inspected.clear();
        this.setModel(model);
    }

    protected void addArray(Node parent, Object obj) {
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(obj, i);
            this.buildTree(parent, "[" + (i + 1) + "]", value, true);
        }
    }

    protected Node buildTree(Node parent, String property, Object obj, boolean element) {
        Node result = new Node(property, obj, element);
        if (parent != null) {
            parent.add(result);
        }
        this.m_Inspected.add(obj);
        if (obj.getClass().isArray()) {
            this.addArray(result, obj);
        }
        try {
            Object current;
            if (obj instanceof OptionHandler) {
                List<AbstractOption> options = ((OptionHandler)obj).getOptionManager().getOptionsList();
                for (AbstractOption option : options) {
                    current = option.getCurrentValue();
                    if (current == null || this.m_Inspected.contains(current)) continue;
                    String label = option.getProperty();
                    if (option instanceof AbstractArgumentOption && ((AbstractArgumentOption)option).isVariableAttached()) {
                        label = label + "/" + ((AbstractArgumentOption)option).getVariable();
                    }
                    this.buildTree(result, label, current, false);
                }
            } else {
                PropertyDescriptor[] descriptors;
                BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
                for (PropertyDescriptor desc : descriptors = bi.getPropertyDescriptors()) {
                    try {
                        if (desc.getReadMethod() == null || desc.getWriteMethod() == null || (current = desc.getReadMethod().invoke(obj, new Object[0])) == null || this.m_Inspected.contains(current) || current.getClass() == Class.class) continue;
                        this.buildTree(result, desc.getDisplayName(), current, false);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to obtain current value for: " + desc.getDisplayName());
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain property descriptors for: " + obj);
            e.printStackTrace();
        }
        for (int i = 0; i < this.m_Handlers.size(); ++i) {
            if (!this.m_Handlers.get(i).handles(obj)) continue;
            Hashtable<String, Object> additional = this.m_Handlers.get(i).inspect(obj);
            for (String key : additional.keySet()) {
                this.buildTree(result, key, additional.get(key), false);
            }
        }
        return result;
    }

    public void setObject(Object value) {
        this.m_Object = value;
        this.buildTree(this.m_Object);
    }

    public Object getObject() {
        return this.m_Object;
    }
}

