/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.data.imagej.Image;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;

public class Command
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 2700141722155551567L;
    protected String m_Command;
    protected String m_CommandOptions;

    public String globalInfo() {
        return "A transformer that allows the execution of ImageJ commands.\nNote(s):\n- the options for the command can be obtained when recording macros\n  in ImageJ";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("command", "command", (Object)"Add Specified Noise...");
        this.m_OptionManager.add("command-options", "commandOptions", (Object)"standard=25");
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The ImageJ command to execute.";
    }

    public void setCommandOptions(String value) {
        this.m_CommandOptions = value;
        this.reset();
    }

    public String getCommandOptions() {
        return this.m_CommandOptions;
    }

    public String commandOptionsTipText() {
        return "The options for the command (not all commands take options).";
    }

    @Override
    protected Image[] doTransform(Image img) {
        ImagePlus imp = img.getImage();
        IJ.run((ImagePlus)imp, (String)this.m_Command, (String)this.m_CommandOptions);
        Image[] result = new Image[]{new Image(imp)};
        return result;
    }

    @Override
    public void cleanUp() {
        WindowManager.closeAllWindows();
        super.cleanUp();
    }
}

