/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.JAIHelper;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import java.awt.image.BufferedImage;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractJAIFlattener
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 4566948525813804085L;
    public static final String METADATA_PREFIX = "metadata-";
    protected Instances m_Header;

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    protected void checkImage(BufferedImage img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    protected abstract Instances createHeader(BufferedImage var1);

    protected abstract Instance doFlatten(BufferedImage var1);

    public Instance flatten(BufferedImage img) {
        this.checkImage(img);
        if (this.m_Header == null) {
            Instances header = this.createHeader(img);
            if (header == null) {
                throw new IllegalStateException("Failed to create header!");
            }
            this.m_Header = header;
        }
        Instance result = this.doFlatten(img);
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractJAIFlattener shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractJAIFlattener shallowCopy(boolean expand) {
        return (AbstractJAIFlattener)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public static String[] getFlatteners() {
        return ClassLister.getSingleton().getClassnames(AbstractJAIFlattener.class);
    }

    public static AbstractJAIFlattener forName(String classname, String[] options) {
        AbstractJAIFlattener result;
        try {
            result = (AbstractJAIFlattener)OptionUtils.forName(AbstractJAIFlattener.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractJAIFlattener forCommandLine(String cmdline) {
        return (AbstractJAIFlattener)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }

    static {
        JAIHelper.disableMediaLib();
    }
}

