/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;
import moa.options.IntOption;
import weka.core.Instance;

public class OzaBag
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "trees.HoeffdingTree");
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models in the bag.", 10, 1, Integer.MAX_VALUE);
    protected Classifier[] ensemble;

    public String getPurposeString() {
        return "Incremental on-line bagging of Oza and Russell.";
    }

    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
        }
    }

    public void trainOnInstanceImpl(Instance inst) {
        for (int i = 0; i < this.ensemble.length; ++i) {
            int k = MiscUtils.poisson(1.0, this.classifierRandom);
            if (k <= 0) continue;
            Instance weightedInst = (Instance)inst.copy();
            weightedInst.setWeight(inst.weight() * (double)k);
            this.ensemble[i].trainOnInstance(weightedInst);
        }
    }

    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        for (int i = 0; i < this.ensemble.length; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(inst));
            if (!(vote.sumOfValues() > 0.0)) continue;
            vote.normalize();
            combinedVote.addValues(vote);
        }
        return combinedVote.getArrayRef();
    }

    public boolean isRandomizable() {
        return true;
    }

    public void getModelDescription(StringBuilder out, int indent) {
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0)};
    }

    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }
}

