/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.CacheWatcher;
import org.jopendocument.util.cache.CacheWatcherFactory;
import org.jopendocument.util.cache.ICache;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ICacheTest {
    private final ThreadGroup thg = new ThreadGroup("testjunit"){

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            ICacheTest.this.threadException = throwable;
        }
    };
    private static final int delay = 1;
    private ICache<String, Object, Object> cache;
    protected Throwable threadException;

    private Thread launch(String string, Runnable runnable) {
        Thread thread = new Thread(this.thg, runnable, string);
        thread.start();
        Thread.yield();
        return thread;
    }

    private void join(Thread thread) throws Throwable {
        thread.join();
        if (this.threadException != null) {
            Throwable throwable = this.threadException;
            this.threadException = null;
            throw throwable;
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.cache = new ICache(1);
    }

    @After
    public void tearDown() throws Exception {
        this.cache = null;
    }

    @Test
    public void testWatcher() throws NoSuchMethodException {
        ICache iCache = new ICache(1);
        iCache.setWatcherFactory(new CacheWatcherFactory<String, String>(){

            @Override
            public CacheWatcher<String, String> createWatcher(ICache<String, ?, String> iCache, String string) throws Exception {
                class BogusCacheWatcher<K, D>
                extends CacheWatcher<K, D> {
                    public BogusCacheWatcher(ICache<K, ?, D> iCache, D d) {
                        super(iCache, d);
                    }

                    public void clear() {
                        this.clearCache();
                    }
                }
                return new BogusCacheWatcher<String, String>(iCache, string);
            }
        });
        ArrayList arrayList = new ArrayList();
        Assert.assertFalse((boolean)iCache.dependsOn("CONTACT_TABLE"));
        Set<CacheWatcher<String, String>> set = iCache.put("SELECT * FROM CONTACT", arrayList, Collections.singleton("CONTACT_TABLE"));
        BogusCacheWatcher bogusCacheWatcher = (BogusCacheWatcher)set.iterator().next();
        iCache.put("SELECT NOM FROM CONTACT", arrayList, Collections.singleton("CONTACT_TABLE"));
        Assert.assertTrue((boolean)iCache.dependsOn("CONTACT_TABLE"));
        iCache.clear("SELECT NOM FROM CONTACT");
        Assert.assertTrue((boolean)iCache.dependsOn("CONTACT_TABLE"));
        Assert.assertSame(arrayList, iCache.get("SELECT * FROM CONTACT").getRes());
        bogusCacheWatcher.clear();
        Assert.assertSame((Object)((Object)CacheResult.State.NOT_IN_CACHE), (Object)((Object)iCache.get("SELECT * FROM CONTACT").getState()));
        Assert.assertFalse((boolean)iCache.dependsOn("CONTACT_TABLE"));
    }

    @Test
    public void testInterrupt() throws Throwable {
        this.getCache().addRunning("SELECT *");
        Thread thread = this.launch("test interrupt", new Runnable(){

            @Override
            public void run() {
                CacheResult cacheResult = ICacheTest.this.getCache().get("SELECT *");
                Assert.assertSame((Object)((Object)CacheResult.State.INTERRUPTED), (Object)((Object)cacheResult.getState()));
            }
        });
        thread.interrupt();
        this.join(thread);
        this.getCache().removeRunning("SELECT *");
    }

    @Test
    public void testGet() throws Throwable {
        Assert.assertEquals((long)0L, (long)this.getCache().size());
        Assert.assertSame((Object)((Object)CacheResult.State.NOT_IN_CACHE), (Object)((Object)this.getCache().get("SELECT 1").getState()));
        this.getCache().put("SELECT 1", new Integer(1), Collections.singleton(1));
        Thread thread = this.launch("test timeout", new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    Assert.fail((String)interruptedException.getMessage());
                }
                Assert.assertSame((Object)((Object)CacheResult.State.NOT_IN_CACHE), (Object)((Object)ICacheTest.this.getCache().get("SELECT 1").getState()));
            }
        });
        Assert.assertEquals((Object)new Integer(1), (Object)this.getCache().get("SELECT 1").getRes());
        this.join(thread);
    }

    @Test
    public void testRunning() throws Throwable {
        Assert.assertFalse((boolean)this.getCache().isRunning("SELECT 2"));
        this.getCache().addRunning("SELECT 2");
        Assert.assertTrue((boolean)this.getCache().isRunning("SELECT 2"));
        final Vector vector = new Vector();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread thread = this.launch("test running", new Runnable(){

            @Override
            public void run() {
                vector.add("begun");
                countDownLatch.countDown();
                vector.add(ICacheTest.this.getCache().get("SELECT 2").getRes());
            }
        });
        countDownLatch.await();
        Assert.assertEquals((long)1L, (long)vector.size());
        Thread.sleep(20L);
        Assert.assertEquals((Object)((Object)Thread.State.WAITING), (Object)((Object)thread.getState()));
        Object object = new Object();
        Assert.assertTrue((boolean)this.getCache().isRunning("SELECT 2"));
        this.getCache().put("SELECT 2", object, Collections.emptySet());
        Assert.assertFalse((boolean)this.getCache().isRunning("SELECT 2"));
        this.join(thread);
        Assert.assertSame((Object)object, vector.get(1));
    }

    @Test
    public void testCheck() {
        Object object = new Object();
        this.getCache().put("SELECT NULL", object, Collections.emptySet());
        Assert.assertSame((Object)object, (Object)this.getCache().check("SELECT NULL").getRes());
        Assert.assertFalse((boolean)this.getCache().isRunning("SELECT NULL"));
    }

    @Test
    public void testSizeAndClear() {
        ICache iCache = new ICache(600, 1);
        iCache.put("a", "A", Collections.emptySet());
        Assert.assertEquals((long)1L, (long)iCache.size());
        iCache.put("b", "B", Collections.emptySet());
        Assert.assertEquals((long)1L, (long)iCache.size());
        Assert.assertSame((Object)((Object)CacheResult.State.NOT_IN_CACHE), (Object)((Object)iCache.get("a").getState()));
    }

    @Test
    public void testClear() {
        this.getCache().put("a", "A", Collections.emptySet());
        Assert.assertEquals((long)1L, (long)this.getCache().size());
        this.getCache().clear("a");
        Assert.assertEquals((long)0L, (long)this.getCache().size());
        this.getCache().clear("b");
        Assert.assertEquals((long)0L, (long)this.getCache().size());
    }

    private ICache<String, Object, Object> getCache() {
        return this.cache;
    }
}

