/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.ZipUtils;
import adams.gui.tools.previewbrowser.AbstractArchiveHandler;
import java.io.File;
import java.util.Vector;

public class ZipArchiveHandler
extends AbstractArchiveHandler {
    private static final long serialVersionUID = 1421258971073361083L;

    public String globalInfo() {
        return "Offers access to ZIP files. Handles the following extensions: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"zip", "jar"};
    }

    protected String[] listFiles() {
        Vector<File> files = ZipUtils.listFiles((File)this.m_Archive, false);
        String[] result = new String[files.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = files.get(i).getPath();
        }
        return result;
    }

    protected boolean doExtract(String archiveFile, File outFile) {
        return ZipUtils.decompress((File)this.m_Archive, archiveFile, outFile);
    }
}

