/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Arrays;
import java.util.HashSet;

public class SpreadSheetInfo
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected Index m_ColumnIndex;

    public String globalInfo() {
        return "Outputs statistics of a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_ROWS);
        this.m_OptionManager.add("column-index", "columnIndex", (Object)"last");
    }

    protected void initialize() {
        super.initialize();
        this.m_ColumnIndex = new Index();
    }

    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("type");
        result = variable != null ? variable : "" + (Object)((Object)this.m_Type);
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.NUM_COLUMNS, InfoType.NUM_ROWS));
        if (!types.contains((Object)this.m_Type)) {
            result = result + ", index: ";
            variable = this.getOptionManager().getVariableForProperty("columnIndex");
            result = variable != null ? result + variable : result + this.m_ColumnIndex.getIndex();
        }
        return result;
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setColumnIndex(String value) {
        this.m_ColumnIndex.setIndex(value);
        this.reset();
    }

    public String getColumnIndex() {
        return this.m_ColumnIndex.getIndex();
    }

    public String columnIndexTipText() {
        return "The column index to use for generating column-specific information. " + this.m_ColumnIndex.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case COLUMN_NAME: {
                return new Class[]{String.class};
            }
            case NUM_COLUMNS: 
            case NUM_ROWS: {
                return new Class[]{Integer.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ColumnIndex.setMax(sheet.getColumnCount());
        int index = this.m_ColumnIndex.getIntIndex();
        switch (this.m_Type) {
            case COLUMN_NAME: {
                if (index == -1) break;
                this.m_OutputToken = new Token((Object)sheet.getHeaderRow().getCell(index).getContent());
                break;
            }
            case NUM_COLUMNS: {
                this.m_OutputToken = new Token((Object)sheet.getColumnCount());
                break;
            }
            case NUM_ROWS: {
                this.m_OutputToken = new Token((Object)sheet.getRowCount());
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InfoType {
        NUM_COLUMNS,
        NUM_ROWS,
        COLUMN_NAME;

    }
}

