/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontParser;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CreateSubset {
    public static byte[][] SubsetTables = new byte[][]{TTFont.TABLE_CMAP, TTFont.TABLE_CVT, TTFont.TABLE_FGPM, TTFont.TABLE_GLYF, TTFont.TABLE_HEAD, TTFont.TABLE_HHEA, TTFont.TABLE_HMTX, TTFont.TABLE_LOCA, TTFont.TABLE_MAXP, TTFont.TABLE_NAME, TTFont.TABLE_OS2, TTFont.TABLE_PREP};
    private final TTFont font;
    private final Set glyphIndices;
    private TTFont result;

    public CreateSubset(TTFont font, Set glyphIndices) {
        this.font = font;
        this.glyphIndices = glyphIndices;
    }

    protected Set addCompositeGlyphs(IRandomAccess glyfRandom, int[] locations, Set glyphs) throws IOException, TrueTypeException {
        HashSet allGlyphs = new HashSet();
        allGlyphs.addAll(glyphs);
        Iterator i = glyphs.iterator();
        while (i.hasNext()) {
            int codePoint = (Integer)i.next();
            this.addCompositeGlyphs(glyfRandom, locations, allGlyphs, codePoint);
        }
        return allGlyphs;
    }

    protected void addCompositeGlyphs(IRandomAccess glyfRandom, int[] locations, Set glyphs, int codePoint) throws IOException, TrueTypeException {
        if (locations[codePoint] == locations[codePoint + 1]) {
            return;
        }
        glyfRandom.seek((long)locations[codePoint]);
        TTFontParser parser = new TTFontParser();
        short numContours = parser.readShort(glyfRandom);
        if (numContours >= 0) {
            return;
        }
        glyfRandom.seekBy(8L);
        while (true) {
            int flags = parser.readUShort(glyfRandom);
            int codePointRef = parser.readUShort(glyfRandom);
            glyphs.add(new Integer(codePointRef));
            if ((flags & 0x20) == 0) {
                return;
            }
            int skip = (flags & 1) != 0 ? 4 : 2;
            if ((flags & 8) != 0) {
                skip += 2;
            } else if ((flags & 0x40) != 0) {
                skip += 4;
            }
            if ((flags & 0x80) != 0) {
                skip += 8;
            }
            glyfRandom.seekBy((long)skip);
        }
    }

    public TTFont compute() throws IOException, TrueTypeException {
        TTTable loca = this.getFont().getTable(TTFont.TABLE_LOCA);
        int[] locations = new TTFontParser().parseTable_loca(loca, this.getFont().getFontHeader().isShortLocationFormat());
        TTTable glyf = this.getFont().getTable(TTFont.TABLE_GLYF);
        IRandomAccess glyfRandom = glyf.getRandomAccess();
        try {
            this.result = this.copySubset();
            this.getGlyphIndices().add(new Integer(0));
            Set compositeGlyphs = this.addCompositeGlyphs(glyfRandom, locations, this.getGlyphIndices());
            this.createGlyphTable(loca, glyf, glyfRandom, locations, compositeGlyphs, this.getFont().getFontHeader().isShortLocationFormat());
            TTFont tTFont = this.result;
            return tTFont;
        }
        finally {
            StreamTools.close((IRandomAccess)glyfRandom);
        }
    }

    protected TTFont copySubset() {
        TTFont resultFont = new TTFont();
        ArrayList<TTTable> newTables = new ArrayList<TTTable>();
        int i = 0;
        while (i < SubsetTables.length) {
            TTTable table = this.getFont().getTable(SubsetTables[i]);
            if (table != null) {
                newTables.add(table);
            }
            ++i;
        }
        resultFont.setTables(newTables.toArray(new TTTable[0]));
        return resultFont;
    }

    protected void createGlyphTable(TTTable loca, TTTable glyf, IRandomAccess glyfRandom, int[] oldLocations, Set glyphs, boolean shortFormat) throws IOException, TrueTypeException {
        int newLength = 0;
        Iterator i = glyphs.iterator();
        while (i.hasNext()) {
            int codePoint = (Integer)i.next();
            if (codePoint + 1 >= oldLocations.length) continue;
            newLength += oldLocations[codePoint + 1] - oldLocations[codePoint];
        }
        newLength = TTFont.align(newLength);
        int[] newLocations = new int[oldLocations.length];
        byte[] newGlyfData = new byte[newLength];
        int ptr = 0;
        int i2 = 0;
        while (i2 < oldLocations.length) {
            int glyfstart;
            int glyflength;
            newLocations[i2] = ptr;
            if (glyphs.contains(new Integer(i2)) && (glyflength = oldLocations[i2 + 1] - (glyfstart = oldLocations[i2])) > 0) {
                glyfRandom.seek((long)glyfstart);
                glyfRandom.read(newGlyfData, ptr, glyflength);
                ptr += glyflength;
            }
            ++i2;
        }
        RandomAccessByteArray random = new RandomAccessByteArray(null);
        TTFontSerializer serializer = new TTFontSerializer();
        serializer.write_loca((IRandomAccess)random, newLocations, shortFormat);
        loca.setBytes(random.toByteArray());
        glyf.setBytes(newGlyfData);
    }

    public TTFont getFont() {
        return this.font;
    }

    public Set getGlyphIndices() {
        return this.glyphIndices;
    }

    public TTFont getResult() {
        return this.result;
    }
}

