/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.HashSet;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Tag;

public class SelectedTag
implements RevisionHandler {
    protected int m_Selected;
    protected Tag[] m_Tags;

    public SelectedTag(int tagID, Tag[] tags) {
        int i;
        HashSet<Integer> ID = new HashSet<Integer>();
        HashSet<String> IDStr = new HashSet<String>();
        for (i = 0; i < tags.length; ++i) {
            ID.add(new Integer(tags[i].getID()));
            IDStr.add(tags[i].getIDStr());
        }
        if (ID.size() != tags.length) {
            throw new IllegalArgumentException("The IDs are not unique!");
        }
        if (IDStr.size() != tags.length) {
            throw new IllegalArgumentException("The ID strings are not unique!");
        }
        for (i = 0; i < tags.length; ++i) {
            if (tags[i].getID() != tagID) continue;
            this.m_Selected = i;
            this.m_Tags = tags;
            return;
        }
        throw new IllegalArgumentException("Selected tag is not valid");
    }

    public SelectedTag(String tagText, Tag[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].getReadable().equalsIgnoreCase(tagText) && !tags[i].getIDStr().equalsIgnoreCase(tagText)) continue;
            this.m_Selected = i;
            this.m_Tags = tags;
            return;
        }
        throw new IllegalArgumentException("Selected tag is not valid");
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        SelectedTag s = (SelectedTag)o;
        return s.getTags() == this.m_Tags && s.getSelectedTag() == this.m_Tags[this.m_Selected];
    }

    public Tag getSelectedTag() {
        return this.m_Tags[this.m_Selected];
    }

    public Tag[] getTags() {
        return this.m_Tags;
    }

    public String toString() {
        return this.getSelectedTag().toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

