/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import moa.classifiers.Classifier;
import moa.classifiers.DecisionStump;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MOAUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOAClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_CLASSIFIER = "classifier";
    protected ClassOption m_Classifier;
    protected Classifier m_ActualClassifier;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Trains a MOA classifier based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLASSIFIER, BACKUP_CLASSIFIER, (Object)this.getDefaultOption());
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1000, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualClassifier = null;
        this.m_Count = 0;
    }

    protected Classifier getDefaultClassifier() {
        return new DecisionStump();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption(BACKUP_CLASSIFIER, 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, this.getDefaultClassifier().getClass().getName().replace("moa.classifiers.", ""), this.getDefaultClassifier().getClass().getName());
    }

    public void setClassifier(ClassOption value) {
        this.m_Classifier = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The MOA classifier to train on the input data and outputs the built classifier alongside the training header (in a model container).\nIf the incoming token does not encapsulate an weka.core.Instance, then only a new instance of the classifier is sent around.";
    }

    protected Classifier getCurrentClassifier() {
        return (Classifier)MOAUtils.fromOption((ClassOption)this.m_Classifier);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to wait before forwarding the trainined classifier.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty(BACKUP_CLASSIFIER);
        String result = variable != null ? variable : this.getCurrentClassifier().getClass().getName().replace("moa.classifiers.", "");
        variable = this.getOptionManager().getVariableForProperty("outputInterval");
        result = variable != null ? result + "/" + variable : result + "/" + this.m_OutputInterval;
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLASSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClassifier != null) {
            result.put(BACKUP_CLASSIFIER, this.m_ActualClassifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLASSIFIER)) {
            this.m_ActualClassifier = (Classifier)state.get(BACKUP_CLASSIFIER);
            state.remove(BACKUP_CLASSIFIER);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class, Classifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                Instance inst = (Instance)this.m_InputToken.getPayload();
                if (this.m_ActualClassifier == null) {
                    this.m_ActualClassifier = this.getCurrentClassifier();
                }
                this.m_ActualClassifier.trainOnInstance(inst);
                ++this.m_Count;
                if (this.m_Count % this.m_OutputInterval == 0) {
                    this.m_Count = 0;
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)this.m_ActualClassifier, new Instances(inst.dataset(), 0)));
                }
            } else {
                Classifier cls = (Classifier)MOAUtils.fromOption((ClassOption)this.m_Classifier);
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualClassifier = null;
    }
}

