/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Properties;
import adams.env.Environment;
import java.io.File;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Placeholders {
    public static final String FILENAME = "Placeholders.props";
    public static final String CWD = "CWD";
    public static final String PROJECT = "PROJECT";
    public static final String TMP = "TMP";
    public static final String HOME = "HOME";
    public static final String PLACEHOLDER_START = "${";
    public static final String PLACEHOLDER_END = "}";
    public static final String SEPARATOR = "=";
    protected static Placeholders m_Singleton;
    protected Properties m_Placeholders;

    private Placeholders() {
        this.initialize();
    }

    protected void initialize() {
        if (this.m_Placeholders == null) {
            try {
                this.m_Placeholders = Environment.getInstance().read("placeholders");
            }
            catch (Exception e) {
                this.m_Placeholders = new Properties();
            }
        }
    }

    public Enumeration<String> placeholders() {
        return this.m_Placeholders.propertyNames();
    }

    public boolean has(String key) {
        return this.m_Placeholders.hasKey(key);
    }

    public String get(String key) {
        String result = this.m_Placeholders.getString(key);
        if (result != null && result.endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public synchronized String set(String key, String value) {
        return (String)this.m_Placeholders.setProperty(key, value);
    }

    public synchronized String remove(String key) {
        return (String)this.m_Placeholders.remove(key);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String expand(String s) {
        String curr;
        StringBuilder result = new StringBuilder();
        String prevStr = curr = s;
        String prevKey = "";
        boolean error = false;
        while (true) {
            boolean finished;
            block10: {
                int pos;
                if ((pos = curr.indexOf(PLACEHOLDER_START)) > -1) {
                    result.append(curr.substring(0, pos));
                    curr = curr.substring(pos + 2, curr.length());
                    pos = curr.indexOf(PLACEHOLDER_END);
                    if (pos > -1) {
                        String key = curr.substring(0, pos);
                        if (key.equals(prevKey)) {
                            System.err.println("Recursive placeholder '" + key + "' when evaluating '" + s + "'!");
                            result = new StringBuilder(s);
                            error = true;
                            break block10;
                        } else {
                            curr = curr.substring(pos + 1, curr.length());
                            String value = this.get(key);
                            if (value != null) {
                                result.append(value);
                            } else {
                                result.append(PLACEHOLDER_START + key + PLACEHOLDER_END);
                                System.err.println("Unknown placeholder: " + key);
                            }
                            prevKey = key;
                            continue;
                        }
                    }
                    result.append(curr.substring(pos));
                    curr = curr.substring(pos + 1, curr.length());
                    continue;
                }
            }
            if (!error && curr.length() > 0) {
                result.append(curr);
            }
            boolean bl = finished = result.indexOf(PLACEHOLDER_START) == -1;
            if (!finished && !error) {
                curr = result.toString();
                if (prevStr.equals(curr)) {
                    System.err.println("Failed to fully expand '" + s + "': " + curr);
                    result = new StringBuilder(s);
                    return result.toString();
                }
                result = new StringBuilder();
            }
            if (finished || error) break;
        }
        return result.toString();
    }

    public String collapse(String s) {
        String result = s;
        String bestKey = null;
        if (result.length() > 0 && !result.equals(".")) {
            int bestLeft = result.length();
            Enumeration<String> pholders = this.placeholders();
            while (pholders.hasMoreElements()) {
                int currLeft;
                String key = pholders.nextElement();
                String value = this.get(key);
                if (value == null || result.indexOf(value) <= -1 || (currLeft = result.replace(value, "").length()) >= bestLeft) continue;
                bestKey = key;
                bestLeft = currLeft;
            }
        } else if (result.equals(".")) {
            result = "${CWD}";
        }
        if (bestKey != null) {
            result = result.replace(this.get(bestKey), PLACEHOLDER_START + bestKey + PLACEHOLDER_END);
        }
        return result;
    }

    public String toString() {
        return this.m_Placeholders.toStringSimple();
    }

    public Properties toProperties() {
        Properties result = new Properties();
        Enumeration<String> enm = this.placeholders();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement();
            result.setProperty(key, this.get(key));
        }
        return result;
    }

    public static synchronized Placeholders getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Placeholders();
        }
        return m_Singleton;
    }

    public static synchronized String expandStr(String s) {
        return Placeholders.getSingleton().expand(s);
    }

    public static synchronized String collapseStr(String s) {
        return Placeholders.getSingleton().collapse(s);
    }
}

