/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerializedObject
implements Serializable {
    private static final long serialVersionUID = 6635502953928860434L;
    private byte[] m_storedObjectArray;
    private boolean m_isCompressed;

    public SerializedObject(Serializable o) throws Exception {
        this(o, false);
    }

    public SerializedObject(Serializable o, boolean compress) throws Exception {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = !compress ? new ObjectOutputStream(new BufferedOutputStream(ostream)) : new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(ostream)));
        p.writeObject(o);
        p.flush();
        p.close();
        this.m_storedObjectArray = ostream.toByteArray();
        this.m_isCompressed = compress;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        byte[] compareArray = ((SerializedObject)o).m_storedObjectArray;
        if (compareArray.length != this.m_storedObjectArray.length) {
            return false;
        }
        for (int i = 0; i < compareArray.length; ++i) {
            if (compareArray[i] == this.m_storedObjectArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_storedObjectArray.length;
    }

    public Object getObject() {
        Object result = null;
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(this.m_storedObjectArray);
            ObjectInputStream p = !this.m_isCompressed ? new ObjectInputStream(new BufferedInputStream(istream)) : new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(istream)));
            result = p.readObject();
            istream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public int size() {
        return this.m_storedObjectArray.length;
    }

    public static boolean write(String filename, Serializable o) {
        return SerializedObject.write(new File(filename), o);
    }

    public static boolean write(File file, Serializable o) {
        boolean result;
        try {
            ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oo.writeObject(o);
            oo.close();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static Object read(String filename) {
        return SerializedObject.read(new File(filename));
    }

    public static Object read(File file) {
        Object result;
        try {
            ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            result = oi.readObject();
            oi.close();
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }
}

