/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Utils;
import adams.core.io.AbstractFormattedSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import java.io.Writer;
import java.util.Enumeration;

public class CsvSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter {
    private static final long serialVersionUID = -3549185519778801930L;

    public String globalInfo() {
        return "Writes CSV files.";
    }

    public String getFormatDescription() {
        return "CSV (comma-separated values)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    protected boolean getUseOutputStream() {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            SpreadSheet.Cell cell;
            String newline = System.getProperty("line.separator");
            for (int i = 0; i < content.getComments().size(); ++i) {
                writer.write("# " + content.getComments().get(i) + newline);
            }
            Enumeration<String> cellKeys = content.getHeaderRow().cellKeys();
            boolean first = true;
            while (cellKeys.hasMoreElements()) {
                cell = content.getHeaderRow().getCell(cellKeys.nextElement());
                if (!first) {
                    writer.write(",");
                }
                if (cell.isMissing()) {
                    writer.write(Utils.doubleQuote(this.m_MissingValue));
                } else {
                    writer.write(Utils.doubleQuote(cell.getContent()));
                }
                first = false;
            }
            writer.write(newline);
            Enumeration<String> rowKeys = content.rowKeys();
            while (rowKeys.hasMoreElements()) {
                SpreadSheet.Row row = content.getRow(rowKeys.nextElement());
                cellKeys = content.getHeaderRow().cellKeys();
                first = true;
                while (cellKeys.hasMoreElements()) {
                    cell = row.getCell(cellKeys.nextElement());
                    if (!first) {
                        writer.write(",");
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        if (cell.isNumeric()) {
                            writer.write(this.format(cell.toDouble()));
                        } else {
                            writer.write(Utils.doubleQuote(cell.getContent()));
                        }
                    } else {
                        writer.write(Utils.doubleQuote(this.m_MissingValue));
                    }
                    first = false;
                }
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

