/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.EnumWithCustomDisplay;
import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionManager;
import adams.gui.goe.Editors;
import adams.gui.goe.EnumEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class EnumOption
extends AbstractArgumentOption {
    private static final long serialVersionUID = -7052702973855610177L;
    protected EnumWithCustomDisplay m_CustomDisplayInstance;

    protected EnumOption(OptionManager owner, String commandline, String property, Object defValue) {
        super(owner, commandline, property, defValue);
    }

    protected EnumOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        super(owner, commandline, property, defValue, outputDefValue);
        Editors.registerCustomEditor(this.getBaseClass(), EnumEditor.class);
        this.m_CustomDisplayInstance = null;
    }

    protected boolean compareValues(Object value, Object defValue) {
        return this.toString(value).equals(this.toString(defValue));
    }

    protected synchronized EnumWithCustomDisplay getCustomDisplayInstance() {
        if (this.m_CustomDisplayInstance == null) {
            try {
                Method method = this.getBaseClass().getMethod("values", new Class[0]);
                Object values = method.invoke(null, new Object[0]);
                this.m_CustomDisplayInstance = (EnumWithCustomDisplay)Array.get(values, 0);
            }
            catch (Exception e) {
                this.m_CustomDisplayInstance = null;
                e.printStackTrace();
            }
        }
        return this.m_CustomDisplayInstance;
    }

    public Object valueOf(String s) throws Exception {
        Enum result = null;
        if (ClassLocator.hasInterface(EnumWithCustomDisplay.class, this.getBaseClass())) {
            EnumWithCustomDisplay value = this.getCustomDisplayInstance();
            if (value != null) {
                result = (Enum)value.parse(s);
            }
        } else if (ClassLocator.isSubclass(Enum.class, this.getBaseClass())) {
            Class<Enum> cl = this.getBaseClass().asSubclass(Enum.class);
            result = Enum.valueOf(cl, s);
        }
        return result;
    }

    public String toString(Object obj) {
        String result = "";
        if (ClassLocator.hasInterface(EnumWithCustomDisplay.class, this.getBaseClass())) {
            result = ((EnumWithCustomDisplay)obj).toRaw();
        } else if (ClassLocator.isSubclass(Enum.class, this.getBaseClass())) {
            result = obj.toString();
        }
        return result;
    }

    protected void addArgumentInfo(StringBuilder buffer) {
        String text = "";
        try {
            Method method = this.getBaseClass().getMethod("values", new Class[0]);
            Object[] vals = (Object[])method.invoke(null, new Object[0]);
            text = Utils.arrayToString(vals).replaceAll(",", "|");
        }
        catch (Exception e) {
            e.printStackTrace();
            text = "Error retrieving enum values";
        }
        buffer.append(" <" + text + ">");
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_CustomDisplayInstance = null;
    }
}

