/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.base.BaseString;
import adams.data.fit.LinearFunction;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import java.util.HashMap;

public class LinearExpression
extends LinearFunction
implements GrammarSupplier {
    private static final long serialVersionUID = 4573621611373361479L;
    protected BaseString[] m_Expressions;

    public String globalInfo() {
        return "Combines the provided expressions in the following form:\n\n  f(x) = expr0 + expr1 + expr2 + ... + exprN\n\nNotes:\n- 'x' must be upper case in the expressions.\n- the coefficients are capital As followed by the index, starting with 0.\n\nThe expressions use the following grammar:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    protected void initialize() {
        super.initialize();
        this.m_Expressions = new BaseString[0];
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expr", "expressions", new BaseString[]{new BaseString("A0"), new BaseString("A1*X"), new BaseString("A2*pow(X,2)"), new BaseString("A3*pow(X,3)")});
    }

    public void setExpressions(BaseString[] value) {
        this.m_Expressions = value;
    }

    public BaseString[] getExpressions() {
        return this.m_Expressions;
    }

    public String expressionsTipText() {
        return "The expressions that make up the formula: expr0 + expr1 + expre2 + -- + exprN.";
    }

    public double[] calcFunctionValues(double x, int num) {
        int i;
        if (num != this.m_Expressions.length) {
            throw new IllegalStateException("Number of functions values differs from number of provided expressions: " + num + " != " + this.m_Expressions.length);
        }
        double[] result = new double[this.m_Expressions.length];
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", new Double(x));
        for (i = 0; i < result.length; ++i) {
            symbols.put("A" + i, new Double(1.0));
        }
        for (i = 0; i < result.length; ++i) {
            try {
                result[i] = MathematicalExpression.evaluate(this.m_Expressions[i].stringValue(), symbols);
                continue;
            }
            catch (Exception e) {
                result[i] = Double.NaN;
                this.getSystemErr().println("Error evaluating '" + this.m_Expressions[i] + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
        return result;
    }

    public double calcY(double x, double[] a) {
        int i;
        if (a.length != this.m_Expressions.length) {
            throw new IllegalStateException("Number of parameters differs from number of provided expressions: " + a.length + " != " + this.m_Expressions.length);
        }
        double result = 0.0;
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", new Double(x));
        for (i = 0; i < a.length; ++i) {
            symbols.put("A" + i, new Double(a[i]));
        }
        for (i = 0; i < a.length; ++i) {
            try {
                result += MathematicalExpression.evaluate(this.m_Expressions[i].stringValue(), symbols);
                continue;
            }
            catch (Exception e) {
                result += Double.NaN;
                this.getSystemErr().println("Error evaluating '" + this.m_Expressions[i] + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
        return result;
    }
}

