/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.data.fit.NonlinearFunction;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import java.util.HashMap;

public class NonlinearExpression
extends NonlinearFunction
implements GrammarSupplier {
    private static final long serialVersionUID = 685629825790681289L;
    protected BaseString[] m_Expressions;
    protected BaseString[] m_PartialExpressions;

    public String globalInfo() {
        return "Combines the provided expressions in the following form:\n\n  f(x) = expr0 + expr1 + expr2 + ... + exprN\n\nExpressions for the partial derivations must be provided as well.Notes:\n- 'x' must be upper case in the expressions.\n- the coefficients can be used in the expressions as 'AN' with 'N' starting from 0.\n\nThe expressions use the following grammar:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    protected void initialize() {
        super.initialize();
        this.m_Expressions = new BaseString[0];
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expr", "expressions", new BaseString[]{new BaseString("A0*exp(A1*X)"), new BaseString("A2*exp(A3*X)")});
        this.m_OptionManager.add("partial-expr", "partialDerivationExpressions", new BaseString[]{new BaseString("exp(A1*X)"), new BaseString("A0*exp(A1*X)*X"), new BaseString("exp(A3*X)"), new BaseString("A2*exp(A3*X)*X")});
    }

    public void setExpressions(BaseString[] value) {
        this.m_Expressions = (BaseString[])value.clone();
    }

    public BaseString[] getExpressions() {
        return (BaseString[])this.m_Expressions.clone();
    }

    public String expressionsTipText() {
        return "The expressions that make up the formula: expr0 + expr1 + expre2 + -- + exprN.";
    }

    public void setPartialDerivationExpressions(BaseString[] value) {
        this.m_PartialExpressions = (BaseString[])value.clone();
    }

    public BaseString[] getPartialDerivationExpressions() {
        return (BaseString[])this.m_PartialExpressions.clone();
    }

    public String partialDerivationExpressionsTipText() {
        return "The partial derivation expressions to use.";
    }

    public double[] calcDerivatives(double x, double[] a) {
        int i;
        if (a.length != this.m_PartialExpressions.length) {
            throw new IllegalStateException("Number of coefficients differs from number of partial derivative expressions: " + a.length + " != " + this.m_PartialExpressions.length);
        }
        double[] result = new double[this.m_PartialExpressions.length];
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", new Double(x));
        for (i = 0; i < a.length; ++i) {
            symbols.put("A" + i, new Double(a[i]));
        }
        for (i = 0; i < this.m_PartialExpressions.length; ++i) {
            try {
                result[i] = MathematicalExpression.evaluate(this.m_PartialExpressions[i].stringValue(), symbols);
                continue;
            }
            catch (Exception e) {
                result[i] = Double.NaN;
                this.getSystemErr().println("Error evaluating '" + this.m_PartialExpressions[i] + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
        this.getDebugging().println("x=" + x + " -> " + Utils.arrayToString(a) + " -> dyda=" + Utils.arrayToString(result));
        return result;
    }

    public double calcY(double x, double[] a) {
        int i;
        double result = 0.0;
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", new Double(x));
        for (i = 0; i < a.length; ++i) {
            symbols.put("A" + i, new Double(a[i]));
        }
        for (i = 0; i < this.m_Expressions.length; ++i) {
            try {
                result += MathematicalExpression.evaluate(this.m_Expressions[i].stringValue(), symbols);
                continue;
            }
            catch (Exception e) {
                a[i] = Double.NaN;
                result += a[i];
                this.getSystemErr().println("Error evaluating '" + this.m_Expressions[i] + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
        this.getDebugging().println("x=" + x + " -> " + Utils.arrayToString(a) + " -> y=" + result);
        return result;
    }
}

