/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.PrefixOnlyField;

public class PrefixField
extends Field
implements PrefixOnlyField {
    private static final long serialVersionUID = 5784651889838784067L;
    public static final String DUMMY_SUFFIX = "DUMMY";

    public PrefixField() {
        this(null, DataType.NUMERIC);
    }

    public PrefixField(AbstractField field) {
        this(field.getName(), field.getDataType());
    }

    public PrefixField(String name, DataType dt) {
        super(name, dt);
        if (this.m_Name != null) {
            this.m_Name = !this.isCompound() ? this.m_Name + "\t" + DUMMY_SUFFIX : this.getPrefix() + "\t" + DUMMY_SUFFIX;
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        AbstractField f = (AbstractField)o;
        if (this.getPrefix() == null && f.getPrefix() == null) {
            return 0;
        }
        if (this.getPrefix() == null) {
            return -1;
        }
        if (f.getPrefix() == null) {
            return 1;
        }
        return this.getPrefix().toLowerCase().compareTo(f.getPrefix().toLowerCase());
    }

    public String toString() {
        if (this.m_Name == null) {
            return "";
        }
        return this.getPrefix();
    }

    public String toDisplayString() {
        return this.toString();
    }

    protected AbstractField newField(String name, DataType dtype) {
        return new PrefixField(name, dtype);
    }

    public static PrefixField parseField(String s) {
        AbstractField tmp = Field.parseField(s);
        PrefixField result = new PrefixField(tmp);
        return result;
    }
}

