/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.StatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMax<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = -4238169529147159807L;
    protected boolean m_ReturnIndex;

    @Override
    public String globalInfo() {
        return "Determines the max value in a numeric array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("return-index", "returnIndex", false);
    }

    public void setReturnIndex(boolean value) {
        this.m_ReturnIndex = value;
        this.reset();
    }

    public boolean getReturnIndex() {
        return this.m_ReturnIndex;
    }

    public String returnIndexTipText() {
        return "If set to true, then the 0-based index of the value is returned instead the actual value.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Number> result = new AbstractArrayStatistic.StatisticContainer<Number>(1, this.size());
        String prefix = "max";
        if (this.m_ReturnIndex) {
            prefix = prefix + "-index";
        }
        if (this.size() > 1) {
            prefix = prefix + "-";
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, prefix + (i + 1));
            } else {
                result.setHeader(i, prefix);
            }
            if (this.m_ReturnIndex) {
                result.setCell(0, i, StatUtils.maxIndex((Number[])this.get(i)));
                continue;
            }
            result.setCell(0, i, StatUtils.max((Number[])this.get(i)));
        }
        return result;
    }
}

