/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.OptionHandlingDatabaseObject;
import adams.env.Environment;
import adams.env.HomeRelocator;
import adams.flow.setup.FlowSetup;
import adams.flow.setup.FlowSetupManager;

public class FlowSetupRunner
extends OptionHandlingDatabaseObject
implements HomeRelocator {
    private static final long serialVersionUID = 8691311691669858254L;
    protected PlaceholderFile m_SetupFile;
    protected String m_SetupName;
    protected String m_Home;

    public String globalInfo() {
        return "Runs a flow control center setup from commandline.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("home", "home", "");
        this.m_OptionManager.add("setup", "setupFile", new PlaceholderFile("."));
        this.m_OptionManager.add("name", "setupName", "");
    }

    public void setHome(String value) {
        this.m_Home = value;
        this.reset();
    }

    public String getHome() {
        return this.m_Home;
    }

    public String homeTipText() {
        return "The directory to use as the project's home directory, overriding the automatically determined one.";
    }

    public void setSetupFile(PlaceholderFile value) {
        this.m_SetupFile = value;
        this.reset();
    }

    public PlaceholderFile getSetupFile() {
        return this.m_SetupFile;
    }

    public String setupFileTipText() {
        return "The setup file to load and execute.";
    }

    public void setSetupName(String value) {
        this.m_SetupName = value;
        this.reset();
    }

    public String getSetupName() {
        return this.m_SetupName;
    }

    public String setupNameTipText() {
        return "The name of the setup to execute.";
    }

    public String execute() {
        return this.execute(false);
    }

    public String execute(boolean wait) {
        String result = null;
        FlowSetup setup = null;
        this.establishDatabaseConnection();
        FlowSetupManager manager = new FlowSetupManager();
        if (!this.m_SetupFile.exists() || this.m_SetupFile.isDirectory()) {
            result = "Setup file '" + this.m_SetupFile + "' does not exist or is directory!";
        }
        if (result == null && !manager.read(this.m_SetupFile.getAbsolutePath())) {
            result = "Error reading setup file '" + this.m_SetupFile + "'!";
        }
        if (result == null) {
            if (manager.indexOf(this.m_SetupName) == -1) {
                result = "Cannot find setup '" + this.m_SetupName + "' in setup file '" + this.m_SetupFile + "'!";
            } else {
                setup = (FlowSetup)manager.get(manager.indexOf(this.m_SetupName));
            }
        }
        if (setup != null && !setup.execute(wait)) {
            result = setup.retrieveLastError();
        }
        return result;
    }

    public static FlowSetupRunner forName(String classname, String[] options) {
        FlowSetupRunner result;
        try {
            result = (FlowSetupRunner)OptionUtils.forName(FlowSetupRunner.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static FlowSetupRunner forCommandLine(String cmdline) {
        return (FlowSetupRunner)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static void runSetup(Class env, Class flow, String[] args) {
        Environment.setEnvironmentClass(env);
        Environment.setHome(OptionUtils.getOption(args, "-home"));
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                FlowSetupRunner setupInst = FlowSetupRunner.forName(flow.getName(), new String[0]);
                System.out.println("\n" + OptionUtils.list(setupInst));
            } else {
                FlowSetupRunner setupInst = FlowSetupRunner.forName(flow.getName(), args);
                String result = setupInst.execute();
                if (result == null) {
                    System.out.println("\nInitiated execution...");
                } else {
                    System.out.println("\n" + result);
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FlowSetupRunner.runSetup(Environment.class, FlowSetupRunner.class, args);
    }
}

