/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.management.ProcessUtils;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Branch
extends AbstractControlActor
implements InputConsumer,
MutableActorHandler {
    private static final long serialVersionUID = -706232800503932715L;
    public static final String BACKUP_CURRENT = "current";
    protected Vector<AbstractActor> m_Branches;
    protected int m_NumThreads;
    protected int m_ActualNumThreads;
    protected ExecutorService m_Executor;
    protected transient Token m_CurrentToken;
    protected boolean m_HasGlobalTransformers;

    @Override
    public String globalInfo() {
        return "Branches off the flow into several sub-branches, each being supplied with a copy of the same object being passed into this meta-actor.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Branches = new Vector();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("branch", "branches", new AbstractActor[0]);
        this.m_OptionManager.add("num-threads", "numThreads", -1, -1, null);
    }

    @Override
    public String getQuickInfo() {
        String result;
        if (this.m_NumThreads == 0 || this.m_NumThreads == 1) {
            result = "sequential";
        } else {
            result = "parallel, threads: ";
            result = this.m_NumThreads == -1 ? result + "#cores" : result + this.m_NumThreads;
        }
        return result;
    }

    public void setBranches(AbstractActor[] value) {
        ActorUtils.uniqueNames(value);
        this.m_Branches.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Branches.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getBranches() {
        return this.m_Branches.toArray(new AbstractActor[this.m_Branches.size()]);
    }

    public String branchesTipText() {
        return "The different branches that branch off and will be supplied with a copy of the same object.";
    }

    public void setNumThreads(int value) {
        this.m_NumThreads = value;
        this.reset();
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public String numThreadsTipText() {
        return "The number of threads to use for executing the branches; -1 = number of CPUs/cores; 0 or 1 = sequential execution.";
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualNumThreads = this.m_NumThreads == -1 ? ProcessUtils.getAvailableProcessors() : (this.m_NumThreads > 1 ? Math.min(this.m_NumThreads, this.size()) : 0);
            if (this.m_ActualNumThreads > 0) {
                this.m_HasGlobalTransformers = this.hasGlobalTransformers();
            }
        }
        return result;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
    }

    @Override
    public int size() {
        return this.m_Branches.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Branches.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index > -1 && index < this.m_Branches.size()) {
            ActorUtils.uniqueName(actor, this, index);
            this.m_Branches.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getSystemErr().println("Index out of range (0-" + (this.m_Branches.size() - 1) + "): " + index);
        }
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Branches.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Branches.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Branches.clear();
        this.reset();
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CurrentToken != null) {
            result.put(BACKUP_CURRENT, this.m_CurrentToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentToken = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        int n;
        Class[] cls;
        AbstractActor actor;
        int i;
        boolean compatible = true;
        Compatibility comp = new Compatibility();
        for (i = 0; i < this.size() - 1; ++i) {
            actor = this.get(i);
            if (actor instanceof InputConsumer) {
                cls = ((InputConsumer)((Object)actor)).accepts();
                for (n = i + 1; n < this.size(); ++n) {
                    AbstractActor actor2 = this.get(n);
                    if (!(actor2 instanceof InputConsumer) || comp.isCompatible(cls, ((InputConsumer)((Object)actor2)).accepts()) || comp.isCompatible(((InputConsumer)((Object)actor2)).accepts(), cls)) continue;
                    compatible = false;
                    break;
                }
            }
            if (!compatible) break;
        }
        Class[] result = compatible ? new Class[]{Unknown.class} : new Class[]{};
        HashSet all = new HashSet();
        for (i = 0; i < this.size(); ++i) {
            actor = this.get(i);
            if (!(actor instanceof InputConsumer)) continue;
            cls = ((InputConsumer)((Object)actor)).accepts();
            HashSet<Class> curr = new HashSet<Class>();
            for (n = 0; n < cls.length; ++n) {
                curr.add(cls[n]);
            }
            if (i == 0) {
                all.addAll(curr);
                continue;
            }
            all.retainAll(curr);
        }
        if (all.size() > 0) {
            result = all.toArray(new Class[all.size()]);
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_CurrentToken = token;
        if (this.getDebugLevel() > 1) {
            this.debug("input token: " + token, 2);
        }
    }

    protected String checkBranch(AbstractActor branch) {
        AbstractDirectedControlActor group;
        String result = null;
        if (!(branch instanceof InputConsumer)) {
            result = "'" + branch.getFullName() + "' doesn't accept tokens!";
        }
        if (result == null && branch instanceof AbstractDirectedControlActor && (result = (group = (AbstractDirectedControlActor)branch).check()) == null) {
            for (int i = 0; i < group.size(); ++i) {
                AbstractActor curr = group.get(i);
                if (curr.getSkip()) continue;
                if (curr instanceof InputConsumer || this.m_CurrentToken == null) break;
                result = "First actor '" + curr.getFullName() + "' does not accept inputs!";
                break;
            }
        }
        if (result != null && this.isDebugOn()) {
            this.debug("Branch '" + branch.getFullName() + "' has errors: " + result);
        }
        return result;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.isDebugOn()) {
                    this.debug("Checking branch #" + (i + 1) + ": " + this.get(i).getFullName());
                }
                if (!this.get(i).getSkip()) {
                    result = this.checkBranch(this.get(i));
                }
                if (result == null) continue;
                result = "Problem in branch " + this.get(i).getFullName() + ": " + result;
                break;
            }
        }
        return result;
    }

    protected boolean hasGlobalTransformers() {
        boolean result = false;
        Hashtable<String, Integer> count = ActorUtils.findGlobalTransformers(this);
        Enumeration<String> names = count.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (count.get(name) <= 1) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeParallel() {
        Object branch;
        int i;
        String result = null;
        if (this.isDebugOn()) {
            this.debug("Starting parallel execution...");
        }
        ArrayList<1> jobs = new ArrayList<1>();
        for (i = 0; i < this.size(); ++i) {
            branch = this.get(i);
            final int index = i;
            if (((AbstractActor)branch).getSkip()) continue;
            Callable<String> job = new Callable<String>((AbstractActor)branch){
                final /* synthetic */ AbstractActor val$branch;
                {
                    this.val$branch = abstractActor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws Exception {
                    String result;
                    if (Branch.this.isDebugOn()) {
                        Branch.this.debug("Executing branch #" + (index + 1) + "...");
                    }
                    if (Branch.this.m_HasGlobalTransformers) {
                        AbstractActor abstractActor = Branch.this.m_Self;
                        synchronized (abstractActor) {
                            ((InputConsumer)((Object)this.val$branch)).input(Branch.this.m_CurrentToken);
                            result = this.val$branch.execute();
                        }
                    } else {
                        ((InputConsumer)((Object)this.val$branch)).input(Branch.this.m_CurrentToken);
                        result = this.val$branch.execute();
                    }
                    if (Branch.this.isDebugOn()) {
                        Branch.this.debug("...finished branch #" + (index + 1) + (result == null ? "" : " with error"));
                    }
                    return result;
                }
            };
            jobs.add(job);
        }
        this.m_Executor = Executors.newFixedThreadPool(this.m_ActualNumThreads);
        List results = null;
        try {
            branch = this.m_Executor;
            synchronized (branch) {
                results = this.m_Executor.invokeAll(jobs);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_Executor.shutdown();
        while (!this.m_Executor.isTerminated()) {
            try {
                this.m_Executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {}
        }
        if (results != null) {
            for (i = 0; i < results.size(); ++i) {
                try {
                    String jobResult = (String)results.get(i).get();
                    if (jobResult == null) continue;
                    result = result == null ? "" : result + ", ";
                    result = result + "Branch #" + (i + 1) + ": " + jobResult;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("Finished parallel execution.");
        }
        return result;
    }

    protected String executeSequential() {
        String result = null;
        if (this.isDebugOn()) {
            this.debug("Starting sequential execution...");
        }
        for (int i = 0; i < this.size(); ++i) {
            AbstractActor actor = this.get(i);
            if (actor.getSkip()) continue;
            if (this.isDebugOn()) {
                this.debug("Executing branch #" + (i + 1) + "...");
            }
            try {
                ((InputConsumer)((Object)actor)).input(this.m_CurrentToken);
                result = actor.execute();
            }
            catch (Exception e) {
                String msg = "Failed to execute branch #" + (i + 1) + ": ";
                result = msg + e;
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace(e);
            }
            if (this.isDebugOn()) {
                this.debug("...finished" + (result == null ? "" : " with error"));
            }
            if (result != null || this.m_Stopped) break;
        }
        if (this.isDebugOn()) {
            this.debug("Finished sequential execution.");
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.m_ActualNumThreads == 0) {
            return this.executeSequential();
        }
        return this.executeParallel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).stopExecution();
        }
        super.stopExecution();
        if (this.m_Executor != null) {
            try {
                ExecutorService executorService = this.m_Executor;
                synchronized (executorService) {
                    this.m_Executor.notifyAll();
                    this.m_Executor.shutdownNow();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void wrapUp() {
        this.m_CurrentToken = null;
        this.m_Executor = null;
        super.wrapUp();
    }
}

