/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.processor.AbstractModifyingProcessor;
import java.lang.reflect.Method;

public class UpdateGlobalActorName
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 3445744354536414039L;
    protected String m_OldName;
    protected String m_NewName;

    public String globalInfo() {
        return "Updates all occurrences of the old global actor name with the new one.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-name", "oldName", "");
        this.m_OptionManager.add("new-name", "newName", "");
    }

    public void setOldName(String value) {
        this.m_OldName = value;
        this.reset();
    }

    public String getOldName() {
        return this.m_OldName;
    }

    public String oldNameTipText() {
        return "The old global actor name to replace with the new one.";
    }

    public void setNewName(String value) {
        this.m_NewName = value;
        this.reset();
    }

    public String getNewName() {
        return this.m_NewName;
    }

    public String newNameTipText() {
        return "The new global actor name that replaces the old one.";
    }

    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            public void handleClassOption(ClassOption option) {
            }

            public void handleBooleanOption(BooleanOption option) {
            }

            public void handleArgumentOption(AbstractArgumentOption option) {
                GlobalActorReference current;
                if (option.getBaseClass().equals(GlobalActorReference.class) && (current = (GlobalActorReference)option.getCurrentValue()).getValue().equals(UpdateGlobalActorName.this.m_OldName)) {
                    System.out.println("Updating: " + UpdateGlobalActorName.this.m_OldName + " -> " + UpdateGlobalActorName.this.m_NewName);
                    Method method = option.getDescriptor().getWriteMethod();
                    try {
                        method.invoke((Object)option.getOptionHandler(), new GlobalActorReference(UpdateGlobalActorName.this.m_NewName));
                        UpdateGlobalActorName.this.m_Modified = true;
                    }
                    catch (Exception e) {
                        UpdateGlobalActorName.this.getSystemErr().println("Failed to update global actor reference '" + option.getProperty() + "' of '" + option.getOptionHandler().getClass().getName() + "':");
                        UpdateGlobalActorName.this.getSystemErr().printStackTrace(e);
                    }
                }
            }

            public boolean canRecurse(Class cls) {
                return true;
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

