/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.ImageViewer;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPanelManager
extends AbstractDisplay
implements MenuBarProvider,
ComponentSupplier,
TextSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = 3365817040968234289L;
    protected HistorySplitPanel m_HistoryPanel;
    protected DisplayPanelProvider m_PanelProvider;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClear;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected JComponentWriterFileChooser m_ComponentFileChooser;
    protected BaseFileChooser m_TextFileChooser;

    public String globalInfo() {
        return "Actor that displays a 'history' of panels created by the selected panel provider. The provider can be an actor that generates classifier errors, for instance.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "panelProvider", new ImageViewer());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo() + ", provider: ";
        String variable = this.getOptionManager().getVariableForProperty("panelProvider");
        result = variable != null ? result + variable : result + this.m_PanelProvider.getClass().getName().replace("adams.flow.sink.", "");
        return result;
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setPanelProvider(DisplayPanelProvider value) {
        this.m_PanelProvider = value;
        this.reset();
    }

    public DisplayPanelProvider getPanelProvider() {
        return this.m_PanelProvider;
    }

    public String panelProviderTipText() {
        return "The actor for generating the display panels.";
    }

    protected BasePanel getSelectedPanel() {
        BasePanel result = null;
        int index = this.m_HistoryPanel.getHistory().getSelectedIndex();
        if (index != -1) {
            result = (BasePanel)this.m_HistoryPanel.getHistory().getEntry(index);
        }
        return result;
    }

    public JComponent supplyComponent() {
        JComponent result = null;
        if (this.m_PanelProvider instanceof ComponentSupplier) {
            result = ((ComponentSupplier)((Object)this.getSelectedPanel())).supplyComponent();
        }
        return result;
    }

    public String supplyText() {
        String result = null;
        if (this.m_PanelProvider instanceof TextSupplier) {
            result = ((TextSupplier)((Object)this.getSelectedPanel())).supplyText();
        }
        return result;
    }

    public void clearPanel() {
        this.m_HistoryPanel.clear();
    }

    protected BasePanel newPanel() {
        HistorySplitPanel result;
        this.m_HistoryPanel = result = new HistorySplitPanel(this);
        return result;
    }

    protected void preCreateFrame(BasePanel panel) {
        super.preCreateFrame(panel);
        this.m_ComponentFileChooser = new JComponentWriterFileChooser();
        this.m_TextFileChooser = new BaseFileChooser();
        this.m_TextFileChooser.addChoosableFileFilter(new ExtensionFileFilter("Text files", "txt"));
        this.m_TextFileChooser.setDefaultExtension("txt");
        this.m_TextFileChooser.setAutoAppendExtension(true);
    }

    public Class[] accepts() {
        if (this.m_PanelProvider != null && this.m_PanelProvider instanceof InputConsumer) {
            return ((InputConsumer)((Object)this.m_PanelProvider)).accepts();
        }
        return new Class[]{Object.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void display(Token token) {
        HistorySplitPanel historySplitPanel = this.m_HistoryPanel;
        synchronized (historySplitPanel) {
            this.m_HistoryPanel.addResult(this.m_PanelProvider.createDisplayPanel(token));
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DisplayPanelManager.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Clear");
        menu.add(menuitem);
        menuitem.setMnemonic('l');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
        menuitem.setIcon(GUIHelper.getIcon("new.gif"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.clear();
            }
        });
        this.m_MenuItemFileClear = menuitem;
        menuitem = new JMenuItem("Save as...");
        menu.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        menu.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DisplayPanelManager.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSaveAs.setEnabled((this.m_PanelProvider instanceof ComponentSupplier || this.m_PanelProvider instanceof TextSupplier) && this.getSelectedPanel() != null);
        this.m_MenuItemFileClear.setEnabled(this.m_HistoryPanel.count() > 0);
    }

    protected void clear() {
        this.m_HistoryPanel.clear();
    }

    protected void saveAs() {
        if (this.m_PanelProvider instanceof TextSupplier) {
            int retVal = this.m_TextFileChooser.showSaveDialog(this.m_HistoryPanel);
            if (retVal != 0) {
                return;
            }
            FileUtils.writeToFile(this.m_TextFileChooser.getSelectedFile().getAbsolutePath(), this.supplyText(), false);
        } else if (this.m_PanelProvider instanceof ComponentSupplier) {
            int retVal = this.m_ComponentFileChooser.showSaveDialog(this.m_HistoryPanel);
            if (retVal != 0) {
                return;
            }
            JComponentWriter writer = this.m_ComponentFileChooser.getWriter();
            writer.setComponent(this.supplyComponent());
            try {
                writer.toOutput();
            }
            catch (Exception e) {
                this.getSystemErr().println("Error saving panel to '" + writer.getFile() + "': ");
                this.getSystemErr().printStackTrace(e);
            }
        }
    }

    protected void close() {
        this.m_HistoryPanel.closeParent();
    }

    protected void cleanUpGUI() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
        this.m_MenuBar = null;
        this.m_MenuItemFileClear = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileClose = null;
        super.cleanUpGUI();
    }

    public Class[] getSendToClasses() {
        if (this.m_PanelProvider instanceof ComponentSupplier) {
            return new Class[]{PlaceholderFile.class, JComponent.class};
        }
        if (this.m_PanelProvider instanceof TextSupplier) {
            return new Class[]{String.class};
        }
        return new Class[]{String.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            return false;
        }
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            if (this.m_PanelProvider instanceof TextSupplier) {
                return this.supplyText() != null && this.supplyText().length() > 0;
            }
        }
        return false;
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            JComponent comp;
            if (this.m_PanelProvider instanceof ComponentSupplier && (comp = this.supplyComponent()) != null) {
                result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                PNGWriter writer = new PNGWriter();
                writer.setFile((PlaceholderFile)result);
                writer.setComponent(comp);
                try {
                    writer.generateOutput();
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to write image to " + result + ":");
                    this.getSystemErr().printStackTrace(e);
                    result = null;
                }
            }
            if (this.m_PanelProvider instanceof TextSupplier) {
                result = this.supplyText();
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls) && this.m_PanelProvider instanceof ComponentSupplier) {
            result = this.supplyComponent();
        }
        return result;
    }

    public static class HistorySplitPanel
    extends BasePanel {
        private static final long serialVersionUID = 5121061351955687610L;
        protected DisplayPanelManager m_Owner;
        protected JSplitPane m_SplitPane;
        protected DisplayPanelHistoryPanel m_History;
        protected BasePanel m_Panel;
        protected SimpleDateFormat m_Format;

        public HistorySplitPanel(DisplayPanelManager owner) {
            super(new BorderLayout());
            this.m_Owner = owner;
            this.m_Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.m_SplitPane = new JSplitPane();
            this.add((Component)this.m_SplitPane, "Center");
            this.m_Panel = new BasePanel(new BorderLayout());
            if (owner.getPanelProvider().displayPanelRequiresScrollPane()) {
                this.m_SplitPane.setBottomComponent(new BaseScrollPane(this.m_Panel));
            } else {
                this.m_SplitPane.setBottomComponent(this.m_Panel);
            }
            this.m_History = new DisplayPanelHistoryPanel();
            this.m_History.setPanel(this.m_Panel);
            this.m_SplitPane.setTopComponent(this.m_History);
            this.m_SplitPane.setResizeWeight(0.1);
            this.m_SplitPane.setDividerLocation(150);
        }

        public DisplayPanelManager getOwner() {
            return this.m_Owner;
        }

        public void clear() {
            this.m_History.clear();
            this.m_Panel.removeAll();
        }

        public int count() {
            return this.m_History.count();
        }

        public DisplayPanelHistoryPanel getHistory() {
            return this.m_History;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addResult(AbstractDisplayPanel result) {
            String baseID;
            SimpleDateFormat simpleDateFormat = this.m_Format;
            synchronized (simpleDateFormat) {
                baseID = this.m_Format.format(new Date());
            }
            String id = baseID;
            int count = 1;
            while (this.m_History.hasEntry(id)) {
                id = baseID + " (" + ++count + ")";
            }
            this.m_History.addEntry(id, result);
            this.m_History.setSelectedIndex(this.count() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayPanelHistoryPanel
    extends AbstractNamedHistoryPanel<AbstractDisplayPanel> {
        private static final long serialVersionUID = 1704390033157269580L;
        protected BasePanel m_Panel;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Panel = null;
        }

        public void setPanel(BasePanel value) {
            this.m_Panel = value;
        }

        @Override
        protected void updateEntry(String name) {
            this.m_Panel.removeAll();
            if (name != null && this.hasEntry(name)) {
                this.m_Panel.add((Component)this.getEntry(name));
                this.m_Panel.getParent().invalidate();
                this.m_Panel.getParent().validate();
                this.m_Panel.getParent().repaint();
            }
        }

        @Override
        public AbstractDisplayPanel removeEntry(String name) {
            AbstractDisplayPanel result = (AbstractDisplayPanel)super.removeEntry(name);
            if (result != null) {
                result.cleanUp();
            }
            return result;
        }
    }
}

