/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.lang.reflect.Array;
import java.util.Vector;

public abstract class AbstractArrayProvider
extends AbstractSource {
    private static final long serialVersionUID = -6681853409971243043L;
    protected Vector m_Queue;
    protected boolean m_OutputArray;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-array", "outputArray", false);
    }

    protected abstract Class getItemClass();

    public void setOutputArray(boolean value) {
        this.m_OutputArray = value;
        this.reset();
    }

    public boolean getOutputArray() {
        return this.m_OutputArray;
    }

    public abstract String outputArrayTipText();

    public Class[] generates() {
        Class[] result;
        if (this.m_OutputArray) {
            Object array = Array.newInstance(this.getItemClass(), 0);
            result = new Class[]{array.getClass()};
        } else {
            result = new Class[]{this.getItemClass()};
        }
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_Queue = new Vector();
    }

    public Token output() {
        Token result;
        if (this.m_OutputArray) {
            Object array = Array.newInstance(this.getItemClass(), this.m_Queue.size());
            for (int i = 0; i < this.m_Queue.size(); ++i) {
                Array.set(array, i, this.m_Queue.get(i));
            }
            result = new Token(array);
            this.m_Queue.clear();
        } else {
            result = new Token(this.m_Queue.get(0));
            this.m_Queue.remove(0);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Queue = null;
    }
}

