/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.management.ProcessUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class Exec
extends AbstractSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Command;
    protected boolean m_OutputStdErr;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Runs an external system command and broadcasts the generated output (stdout or stderr).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", "ls -l .");
        this.m_OptionManager.add("stderr", "outputStdErr", false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("command");
        if (variable != null) {
            return variable;
        }
        if (this.m_Command != null && this.m_Command.length() != 0) {
            return this.m_Command;
        }
        return null;
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    public void setOutputStdErr(boolean value) {
        this.m_OutputStdErr = value;
        this.reset();
    }

    public boolean getOutputStdErr() {
        return this.m_OutputStdErr;
    }

    public String outputStdErrTipText() {
        return "If set to true, then stderr is output instead of stdout.";
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Object output = ProcessUtils.execute(this.m_Command, this.m_OutputStdErr);
            if (output instanceof Integer) {
                result = "Command '" + this.m_Command + "' returned " + output;
            } else {
                this.m_OutputToken = new Token(output.toString());
            }
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

