/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.ActorUtils;
import adams.flow.source.AbstractDatabaseIdSupplier;
import adams.flow.standalone.DatabaseConnection;
import java.sql.ResultSet;
import java.util.Vector;

public class SQLIdSupplier
extends AbstractDatabaseIdSupplier {
    private static final long serialVersionUID = -2269772801929933064L;
    protected SQLStatement m_SQL;
    protected Type m_Type;

    public String globalInfo() {
        return "Executes an SQL statement for generating the IDs.\nVariables are automatically expanded.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", new SQLStatement("select auto_id from table"));
        this.m_OptionManager.add("type", "type", (Object)Type.INTEGER);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("type");
        String result = variable != null ? variable : this.m_Type.toString();
        result = result + ": ";
        variable = this.getOptionManager().getVariableForProperty("SQL");
        result = variable != null ? result + variable : result + Utils.shorten(this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), 50);
        return result;
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement to run that generates the IDs.";
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of IDs to generate.";
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case INTEGER: {
                return Integer.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
    }

    protected Vector getIDs() {
        Vector<Object> result = new Vector<Object>();
        ResultSet rs = null;
        try {
            SQL sql = new SQL(this.getDatabaseConnection());
            String query = this.m_SQL.getValue();
            query = this.getVariables().expand(query);
            if (this.isDebugOn()) {
                this.debug("Query: " + query);
            }
            rs = sql.getResultSet(query);
            block6: while (rs.next()) {
                switch (this.m_Type) {
                    case INTEGER: {
                        result.add(rs.getInt(1));
                        continue block6;
                    }
                    case STRING: {
                        result.add(rs.getString(1));
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
            }
            if (this.isDebugOn()) {
                this.debug("--> " + result.size() + " IDs");
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to obtain IDs: ");
            this.getSystemErr().printStackTrace(e);
        }
        SQL.closeAll(rs);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INTEGER,
        STRING;

    }
}

