/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.id.AbstractIDGenerator;
import adams.data.id.SimpleIDGenerator;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class IDGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 7195919809805609634L;
    protected AbstractIDGenerator m_Generator;

    public String globalInfo() {
        return "Generates IDs from the objects it receives on its input and forwards the generated IDs.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new SimpleIDGenerator());
    }

    public void setGenerator(AbstractIDGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractIDGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the IDs.";
    }

    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Object obj = this.m_InputToken.getPayload();
            String id = this.m_Generator.generate(obj);
            this.m_OutputToken = new Token(new String(id));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

