/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class MoveFile
extends AbstractTransformer {
    private static final long serialVersionUID = -1725398133887399010L;
    protected PlaceholderFile m_File;
    protected boolean m_InputIsTarget;

    public String globalInfo() {
        return "Moves a file to a different location (or just renames it).\nSource and target can be swapped as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("input-is-target", "inputIsTarget", false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("file");
        String result = variable != null ? variable : "" + this.m_File;
        if (this.m_InputIsTarget) {
            result = result + " (input is target)";
        }
        return result;
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The target file.";
    }

    public void setInputIsTarget(boolean value) {
        this.m_InputIsTarget = value;
        this.reset();
    }

    public boolean getInputIsTarget() {
        return this.m_InputIsTarget;
    }

    public String inputIsTargetTipText() {
        return "If true, then the input token will be used as target and the file parameter as source.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result;
        try {
            PlaceholderFile source;
            PlaceholderFile target;
            PlaceholderFile file = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
            if (this.m_InputIsTarget) {
                target = file;
                source = this.m_File;
            } else {
                target = this.m_File;
                source = file;
            }
            this.debug("Source '" + source + "' exists: " + ((File)source).exists());
            this.debug("Target '" + target + "' exists: " + ((File)target).exists());
            FileUtils.move(source.getAbsoluteFile(), target.getAbsoluteFile());
            result = null;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        return result;
    }
}

