/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.env.Environment;
import adams.gui.core.BaseDialog;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;

public class GenericObjectEditorDialog
extends BaseDialog
implements ActionListener {
    private static final long serialVersionUID = 450801082654308978L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    protected PropertyEditor m_Editor;
    protected Object m_Current;
    protected int m_Result;

    public GenericObjectEditorDialog(Dialog owner) {
        super(owner);
    }

    public GenericObjectEditorDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public GenericObjectEditorDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public GenericObjectEditorDialog(Dialog owner, String title, Dialog.ModalityType modality) {
        super(owner, title, modality);
    }

    public GenericObjectEditorDialog(Frame owner) {
        super(owner);
    }

    public GenericObjectEditorDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public GenericObjectEditorDialog(Frame owner, String title) {
        super(owner, title);
    }

    public GenericObjectEditorDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    protected void initialize() {
        super.initialize();
        this.m_Editor = new GenericObjectEditor();
        this.m_Current = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.m_Editor.getCustomEditor(), "Center");
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addOkListener(this);
        this.pack();
    }

    public void setEditor(PropertyEditor value) {
        if (this.m_Editor.getCustomEditor() instanceof GenericObjectEditor.GOEPanel) {
            ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).removeOkListener(this);
        }
        this.getContentPane().remove(0);
        this.m_Editor = value;
        if (this.m_Editor.getCustomEditor() instanceof GenericObjectEditor.GOEPanel) {
            ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addOkListener(this);
        }
        this.getContentPane().add(this.m_Editor.getCustomEditor(), "Center");
        this.pack();
    }

    public PropertyEditor getEditor() {
        return this.m_Editor;
    }

    public boolean isGOEEditor() {
        return this.m_Editor instanceof GenericObjectEditor;
    }

    public GenericObjectEditor getGOEEditor() {
        if (this.m_Editor instanceof GenericObjectEditor) {
            return (GenericObjectEditor)this.m_Editor;
        }
        return null;
    }

    protected void beforeShow() {
        super.beforeShow();
        this.m_Current = this.m_Editor.getValue();
        this.m_Result = this.m_Editor.getCustomEditor() instanceof GenericObjectEditor.GOEPanel ? 1 : 0;
        GUIHelper.adjustSize(this);
    }

    public void setCurrent(Object value) {
        this.m_Editor.setValue(value);
        this.m_Current = value;
        GUIHelper.adjustSize(this);
    }

    public Object getCurrent() {
        return this.m_Current;
    }

    public int getResult() {
        return this.m_Result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.m_Current = this.m_Editor.getValue();
            this.m_Result = 0;
            this.setVisible(false);
        }
    }

    public static GenericObjectEditorDialog createDialog(Container parent) {
        return GenericObjectEditorDialog.createDialog(parent, null);
    }

    public static GenericObjectEditorDialog createDialog(Container parent, PropertyEditor editor) {
        return GenericObjectEditorDialog.createDialog(parent, editor, null);
    }

    public static GenericObjectEditorDialog createDialog(Container parent, PropertyEditor editor, Object value) {
        GenericObjectEditorDialog result = GUIHelper.getParentDialog(parent) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog(parent)) : new GenericObjectEditorDialog(GUIHelper.getParentFrame(parent));
        result.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        result.setTitle("Object editor");
        if (editor != null) {
            result.setEditor(editor);
        }
        if (value != null) {
            result.setCurrent(value);
        }
        return result;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GenericObjectEditorDialog dialog = new GenericObjectEditorDialog((Frame)null, "Object editor", true);
        dialog.setDefaultCloseOperation(2);
        dialog.getGOEEditor().setClassType(AbstractFilter.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.setCurrent(new PassThrough());
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            System.out.println(dialog.getCurrent());
        }
    }
}

