/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.io.FilenameProposer;
import adams.env.Environment;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.event.ScriptingEvent;
import adams.gui.event.ScriptingListener;
import adams.gui.scripting.ScriptingLogger;
import adams.gui.scripting.SyntaxDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;

public class ScriptingLogPanel
extends BasePanel
implements ScriptingListener {
    private static final long serialVersionUID = 7316507289818697814L;
    protected JTextPane m_TextLog;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonClose;
    protected JButton m_ButtonSave;
    protected BaseFileChooser m_FileChooser;
    protected FilenameProposer m_FilenameProposer;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.addChoosableFileFilter(ExtensionFileFilter.getLogFileFilter());
        this.m_FileChooser.setDefaultExtension(ExtensionFileFilter.getLogFileFilter().getExtensions()[0]);
        this.m_FilenameProposer = new FilenameProposer("new", this.m_FileChooser.getDefaultExtension());
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextLog = new JTextPane(){
            private static final long serialVersionUID = -8867551408542402385L;

            public void setSize(Dimension d) {
                if (d.width < this.getGraphicsConfiguration().getBounds().width) {
                    d.width = this.getGraphicsConfiguration().getBounds().width;
                }
                super.setSize(d);
            }

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.m_TextLog.setDocument(this.createDocument());
        this.add((Component)new BaseScrollPane(this.m_TextLog), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.add((Component)panel, "South");
        this.m_ButtonClear = new JButton("Clear", GUIHelper.getIcon("new.gif"));
        this.m_ButtonClear.setMnemonic('e');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptingLogPanel.this.clear();
            }
        });
        panel.add(this.m_ButtonClear);
        this.m_ButtonSave = new JButton("Save...", GUIHelper.getIcon("save.gif"));
        this.m_ButtonSave.setMnemonic('s');
        this.m_ButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptingLogPanel.this.save();
            }
        });
        panel.add(this.m_ButtonSave);
        this.m_ButtonClose = new JButton("Close", GUIHelper.getIcon("exit.png"));
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptingLogPanel.this.close();
            }
        });
        panel.add(this.m_ButtonClose);
    }

    protected void finishInit() {
        ScriptingLogger.getSingleton().addScriptingListener(this);
    }

    protected Document createDocument() {
        Properties props = Environment.getInstance().read("scripting dialog");
        SyntaxDocument result = new SyntaxDocument(props);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        JTextPane jTextPane = this.m_TextLog;
        synchronized (jTextPane) {
            this.m_TextLog.setText("");
        }
    }

    protected void save() {
        this.m_FileChooser.setSelectedFile(this.m_FilenameProposer.propose(null));
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        if (!FileUtils.writeToFile(this.m_FileChooser.getSelectedFile().getAbsolutePath(), this.m_TextLog.getText(), false)) {
            GUIHelper.showErrorMessage(this, "Error saving log to file '" + this.m_FileChooser.getSelectedFile() + "'!");
        }
    }

    protected void close() {
        ScriptingLogger.getSingleton().removeScriptingListener(this);
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptingCommandExecuted(ScriptingEvent e) {
        String line = "";
        line = e.getCmd().getBasePanel() != null ? line + e.getCmd().getBasePanel().getClass().getName().replaceAll(".*\\.", "") : line + "[unknown]";
        line = line + " (" + (e.getSuccess() ? "successful" : "failed") + ")";
        line = line + ": " + e.getCmd().getCommand();
        if (e.hasError()) {
            line = line + "\n   " + e.getError();
        }
        line = line + "\n";
        JTextPane jTextPane = this.m_TextLog;
        synchronized (jTextPane) {
            Document doc;
            Document document = doc = this.m_TextLog.getDocument();
            synchronized (document) {
                try {
                    doc.insertString(doc.getLength(), line, null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

