/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.core.BaseTable;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.ContainerModel;
import adams.gui.visualization.container.ContainerTableCellRenderer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerTable<M extends ContainerManager, C extends Container>
extends BaseTable {
    private static final long serialVersionUID = -7750679423202155069L;
    protected boolean m_ColumnWidthsSet;

    public ContainerTable() {
        this(new ContainerModel((ContainerManager)null));
    }

    public ContainerTable(ContainerModel<M, C> model) {
        super(model);
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(String.class, new ContainerTableCellRenderer());
        this.setDefaultRenderer(Integer.class, new ContainerTableCellRenderer());
        this.setDefaultRenderer(Double.class, new ContainerTableCellRenderer());
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ContainerTable.this.removeContainers(ContainerTable.this.getSelectedRows());
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.resizeAndRepaint();
    }

    public void removeAllContainers() {
        this.removeContainers(null);
    }

    public void removeContainers(int[] indices) {
        if (indices != null && indices.length == 0) {
            return;
        }
        M manager = this.getManager();
        if (indices == null) {
            ((ContainerManager)manager).clear();
        } else if (indices.length > 1) {
            ((ContainerManager)manager).startUpdate();
            for (int i = indices.length - 1; i >= 0; --i) {
                ((ContainerManager)manager).remove(indices[i]);
            }
            ((ContainerManager)manager).finishUpdate();
        } else {
            ((ContainerManager)manager).remove(indices[0]);
        }
    }

    @Override
    public void setModel(TableModel value) {
        if (!(value instanceof ContainerModel)) {
            throw new IllegalArgumentException("Only models of type " + ContainerModel.class.getName() + " can be used!");
        }
        if (this.getModel() instanceof ContainerModel) {
            ((ContainerModel)this.getModel()).unregister();
        }
        super.setModel(value);
        this.m_ColumnWidthsSet = false;
    }

    protected void updateColumnWidths() {
        if (this.getModel() == null) {
            return;
        }
        if (this.getColumnCount() != this.getColumnModel().getColumnCount()) {
            return;
        }
        if (this.getTableHeader() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ContainerModel model = (ContainerModel)ContainerTable.this.getModel();
                TableColumnModel colModel = ContainerTable.this.getColumnModel();
                ContainerModel containerModel = model;
                synchronized (containerModel) {
                    TableColumnModel tableColumnModel = colModel;
                    synchronized (tableColumnModel) {
                        for (int i = 0; i < colModel.getColumnCount(); ++i) {
                            colModel.getColumn(i).setPreferredWidth(model.getColumnWidth(i));
                        }
                    }
                }
            }
        };
        this.m_ColumnWidthsSet = true;
        SwingUtilities.invokeLater(runnable);
    }

    public boolean isColumnWidthsSet() {
        return this.m_ColumnWidthsSet;
    }

    public void invalidateColumnWidths() {
        this.m_ColumnWidthsSet = false;
        super.invalidate();
    }

    @Override
    public void revalidate() {
        super.revalidate();
        if (!this.isColumnWidthsSet()) {
            this.updateColumnWidths();
        }
    }

    public M getManager() {
        if (this.getModel() != null) {
            return ((ContainerModel)this.getModel()).getManager();
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1) {
            this.m_ColumnWidthsSet = false;
        }
        super.tableChanged(e);
    }
}

