/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;

public class XYSequenceDotHitDetector
extends AbstractXYSequencePointHitDetector {
    private static final long serialVersionUID = -3363546923840405674L;
    protected XYSequencePanel m_Owner;

    public XYSequenceDotHitDetector(XYSequencePanel owner) {
        super(owner);
    }

    protected Object isHit(MouseEvent e) {
        if (this.m_Owner == null) {
            return null;
        }
        Vector<XYSequencePoint> result = new Vector<XYSequencePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        for (int i = 0; i < ((XYSequenceContainerManager)this.m_Owner.getContainerManager()).count(); ++i) {
            int index;
            if (!((VisibilityContainer)((XYSequenceContainerManager)this.m_Owner.getContainerManager()).get(i)).isVisible()) continue;
            XYSequence s = ((XYSequenceContainer)((XYSequenceContainerManager)this.m_Owner.getContainerManager()).get(i)).getData();
            List<XYSequencePoint> points = s.toList();
            if (this.getDebug()) {
                this.getDebugging().println("\n" + s.getID() + ":");
            }
            if ((index = XYSequenceUtils.findClosestX(points, x)) == -1) continue;
            XYSequencePoint sp = points.get(index);
            double diffX = ((Number)sp.getX()).doubleValue() - x;
            double diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
            if (this.getDebug()) {
                this.getDebugging().println("diff x=" + diffPixel);
            }
            if (diffPixel > (double)this.m_MinimumPixelDifference) continue;
            double diffY = ((Number)sp.getY()).doubleValue() - y;
            diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
            if (this.getDebug()) {
                this.getDebugging().println("diff y=" + diffPixel);
            }
            if (diffPixel > (double)this.m_MinimumPixelDifference) continue;
            if (this.getDebug()) {
                this.getDebugging().println("hit!");
            }
            result.add(sp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }
}

