/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.Freetype;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.NullPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeFont;
import de.intarsys.pdf.platform.cwt.font.freetype.PACKAGE;
import de.intarsys.pdf.platform.cwt.font.type3.Type3FontFactory;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FreetypeFontFactory
implements IPlatformFontFactory {
    private static ResourceTracker tracker = new ResourceTracker(100){

        protected void basicDispose(Object resource) {
            ((Face)resource).doneFace();
        }
    };
    private static final Logger Log = PACKAGE.Log;
    private static Library library;
    private static final Attribute ATTR_PLATFORMFONT;
    private Type3FontFactory type3FontFactory = new Type3FontFactory();
    private NullPlatformFontFactory nullFontFactory = new NullPlatformFontFactory();

    static {
        ATTR_PLATFORMFONT = new Attribute("platformFont");
    }

    protected static synchronized Library getLibrary() {
        if (library == null) {
            library = Freetype.initFreeType();
        }
        return library;
    }

    protected static Face loadFace(byte[] fontdata, int index) {
        return FreetypeFontFactory.getLibrary().newMemoryFace(fontdata, index);
    }

    protected static void registerPlatformFont(IAttributeSupport as, IPlatformFont object) {
        as.setAttribute((Object)ATTR_PLATFORMFONT, (Object)object);
    }

    protected IPlatformFont basicCreate(PDFont font) throws PlatformFontException {
        if (font instanceof PDFontType3) {
            return this.type3FontFactory.createPlatformFont(font);
        }
        Face face = null;
        PDFontDescriptor pdDesc = null;
        try {
            pdDesc = font.getFontDescriptor();
        }
        catch (COSRuntimeException cOSRuntimeException) {
            // empty catch block
        }
        if (pdDesc != null) {
            byte[] fontdata = null;
            fontdata = pdDesc.getFontFile();
            if (fontdata == null) {
                fontdata = pdDesc.getFontFile2();
            }
            if (fontdata == null) {
                fontdata = pdDesc.getFontFile3();
            }
            if (fontdata != null) {
                face = FreetypeFontFactory.loadFace(fontdata, 0);
            }
        }
        if (face == null) {
            face = this.getExternalFont(font);
        }
        if (face == null) {
            Log.log(Level.WARNING, "can't load font '" + font.getBaseFont() + "'");
            return this.nullFontFactory.createPlatformFont(font);
        }
        this.selectCharacterMap(font, face);
        FreetypeFont result = new FreetypeFont(font, face);
        tracker.trackPhantom((Object)font, (Object)face);
        return result;
    }

    public synchronized IPlatformFont createPlatformFont(PDFont font) throws PlatformFontException {
        FreetypeFontFactory.getLibrary();
        IPlatformFont result = (IPlatformFont)font.getAttribute((Object)ATTR_PLATFORMFONT);
        if (result == null) {
            result = this.basicCreate(font);
            FreetypeFontFactory.registerPlatformFont((IAttributeSupport)font, result);
        }
        return result;
    }

    protected Face getExternalFont(PDFont pdFont) throws CSException {
        IFont font = PlatformFontTools.getCWTFont(pdFont);
        if (font != null) {
            return this.loadFace(font);
        }
        return null;
    }

    protected Face loadFace(IFont font) {
        InputStream is = null;
        try {
            is = font.getFontProgram().getLocator().getInputStream();
            byte[] fontdata = StreamTools.toByteArray((InputStream)is);
            return FreetypeFontFactory.loadFace(fontdata, 0);
        }
        catch (IOException e) {
            StreamTools.close(is);
            return null;
        }
    }

    protected boolean selectCharacterMap(Face face, int platform, int encoding) {
        int num = face.getNumCharMaps();
        if (num == 0) {
            return false;
        }
        int index = 0;
        while (index < num) {
            CharMap map = face.getCharMap(index);
            if (map.getPlatformID() == platform && (encoding == -1 || map.getEncodingID() == encoding)) {
                face.setCharMap(map);
                return true;
            }
            ++index;
        }
        return false;
    }

    protected void selectCharacterMap(PDFont pdFont, Face face) {
        PDFontDescriptor fontDescriptor = null;
        try {
            fontDescriptor = pdFont.getFontDescriptor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (fontDescriptor == null) {
            if (!this.selectCharacterMap(face, 3, 1)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (fontDescriptor.isSymbolic()) {
            if (pdFont instanceof PDFontType1) {
                this.selectCharacterMap(face, 7, -1);
            } else if (pdFont instanceof PDFontTrueType) {
                boolean selected = this.selectCharacterMap(face, 3, 0);
                if (!selected) {
                    this.selectCharacterMap(face, 1, 0);
                }
            } else if (!(pdFont instanceof PDFontType0)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (pdFont instanceof PDFontType1) {
            this.selectCharacterMap(face, 3, 1);
        } else if (pdFont instanceof PDFontTrueType) {
            if (!this.selectCharacterMap(face, 3, 1)) {
                this.selectCharacterMap(face, 1, 0);
            }
        } else if (!(pdFont instanceof PDFontType0)) {
            this.selectCharacterMap(face, 3, 1);
        }
    }
}

