/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.clusterers.Clusterer;
import weka.clusterers.EM;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddCluster;

public class AddClusterTest
extends AbstractFilterTest {
    public AddClusterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (!this.m_Instances.attribute(i).isNominal() && !this.m_Instances.attribute(i).isNumeric() || this.m_Instances.attribute(i).isDate()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    protected Clusterer getClusterer() {
        EM c = new EM();
        try {
            c.setOptions(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public Filter getFilter() {
        AddCluster f = new AddCluster();
        f.setClusterer(this.getClusterer());
        return f;
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier((Classifier)new J48());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities((Capabilities)this.m_FilteredClassifier.getCapabilities());
        test.setClassType(1);
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        AddClusterTest.assertEquals((int)(this.m_Instances.numAttributes() + 1), (int)result.numAttributes());
        AddClusterTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(AddClusterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddClusterTest.suite());
    }
}

