/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.jopendocument.util.ImageInfo;

public class ImageUtils {
    public static BufferedImage createSmallerImage(File file, int n, int n2) throws IOException {
        ImageInfo imageInfo = new ImageInfo();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        imageInfo.setInput(bufferedInputStream);
        if (!imageInfo.check()) {
            throw new IllegalStateException("unable to parse the picture");
        }
        bufferedInputStream.close();
        int n3 = imageInfo.getWidth();
        int n4 = imageInfo.getHeight();
        if (n3 <= n && n4 <= n2) {
            return null;
        }
        Image image = new ImageIcon(file.getAbsolutePath()).getImage();
        return ImageUtils.createSmallerImage(image, n, n2);
    }

    public static BufferedImage createSmallerImage(Image image, int n, int n2) {
        int n3;
        int n4;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n5 <= n && n6 <= n2) {
            return null;
        }
        float f = (float)n5 / (float)n6;
        float f2 = n / n2;
        if (f > f2) {
            n4 = n;
            n3 = (int)((float)n4 / f);
        } else {
            n3 = n2;
            n4 = (int)((float)n3 * f);
        }
        return ImageUtils.createQualityResizedImage(image, n4, n3);
    }

    public static BufferedImage createQualityResizedImage(Image image, float f, boolean bl, Color color, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4 = image.getWidth(null);
        float f2 = (float)n4 / (float)(n3 = image.getHeight(null));
        if (f > f2) {
            n2 = n3;
            n = (int)((float)n2 * f);
        } else {
            n = n4;
            n2 = (int)((float)n / f);
        }
        return ImageUtils.createQualityResizedImage(image, n, n2, false, true, color, bl2);
    }

    public static BufferedImage createQualityResizedImage(Image image, int n, int n2, boolean bl, boolean bl2, Color color, boolean bl3) {
        if (image == null) {
            throw new IllegalArgumentException("null argument");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        int n3 = 4;
        if (bl3) {
            n3 = 2;
        }
        if (!bl2) {
            Image image2 = image.getScaledInstance(n, n2, n3);
            Image image3 = new ImageIcon(image2).getImage();
            graphics2D.drawImage(image3, 0, 0, null);
        } else {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
            float f = n;
            float f2 = n2;
            float f3 = image.getWidth(null);
            float f4 = image.getHeight(null);
            float f5 = f3 / f4;
            float f6 = f / f2;
            if (f6 > f5) {
                int n4 = Math.round(f2 * f5);
                int n5 = Math.round(f2);
                Image image4 = image.getScaledInstance(n4, n5, n3);
                Image image5 = new ImageIcon(image4).getImage();
                graphics2D.drawImage(image5, (int)((f - (float)n4) / 2.0f), 0, null);
            } else {
                int n6 = Math.round(f);
                int n7 = Math.round(f / f5);
                Image image6 = image.getScaledInstance(n6, n7, n3);
                Image image7 = new ImageIcon(image6).getImage();
                graphics2D.drawImage(image7, 0, (int)((f2 - (float)n7) / 2.0f), null);
            }
        }
        graphics2D.dispose();
        if (bl) {
            return ImageUtils.getSoftFilteredImage(bufferedImage);
        }
        return bufferedImage;
    }

    public static BufferedImage createQualityResizedImage(Image image, int n, int n2) {
        return ImageUtils.createQualityResizedImage(image, n, n2, false, false, Color.WHITE, false);
    }

    public static BufferedImage createQualityResizedImage(Image image, int n, int n2, boolean bl) {
        return ImageUtils.createQualityResizedImage(image, n, n2, false, bl, Color.WHITE, false);
    }

    public static BufferedImage getSoftFilteredImage(BufferedImage bufferedImage) {
        float f = 0.01f;
        float[] fArray = new float[]{0.0f, f, 0.0f, f, 1.0f - f * 3.0f, f, 0.0f, f, 0.0f};
        Kernel kernel = new Kernel(3, 3, fArray);
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = convolveOp.filter(bufferedImage, null);
        return bufferedImage;
    }
}

