/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.visualization.stats.paintlet.AbstractZScorePaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ZScoreCircle
extends AbstractZScorePaintlet {
    private static final long serialVersionUID = -2909051757826954366L;
    protected int m_Size;
    protected boolean m_Fill;
    protected Color m_FillColor;

    public String globalInfo() {
        return "paintlet for plotting cirle points on the z score visualisation";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)5, (Number)1, null);
        this.m_OptionManager.add("fill-point", "fillPoint", (Object)false);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)Color.RED);
    }

    public void setFillColor(Color val) {
        this.m_FillColor = val;
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "Color for filling data points";
    }

    public void setFillPoint(boolean val) {
        this.m_Fill = val;
        this.memberChanged();
    }

    public boolean getFillPoint() {
        return this.m_Fill;
    }

    public String fillPointTipText() {
        return "Whether to fill the data point with solid color";
    }

    public void setSize(int val) {
        this.m_Size = val;
        this.memberChanged();
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of each data point.";
    }

    protected void drawData(Graphics g) {
        super.drawData(g);
        for (int i = 0; i < this.m_Data.length; ++i) {
            int posX = this.m_AxisBottom.valueToPos((double)i);
            int posY = this.m_AxisLeft.valueToPos(this.m_Data[i]);
            Graphics2D g2d = (Graphics2D)g;
            if (this.m_Fill) {
                g2d.setColor(this.m_FillColor);
                g2d.setStroke(new BasicStroke(0.0f));
                g2d.fillOval(posX - (int)(0.5 * (double)this.m_Size), posY - (int)(0.5 * (double)this.m_Size), this.m_Size, this.m_Size);
            }
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.setColor(this.m_Color);
            g2d.drawOval(posX - (int)(0.5 * (double)this.m_Size), posY - (int)(0.5 * (double)this.m_Size), this.m_Size, this.m_Size);
            if (i + 1 >= this.m_Data.length) continue;
            int posX2 = this.m_AxisBottom.valueToPos((double)(i + 1));
            int posY2 = this.m_AxisLeft.valueToPos(this.m_Data[i + 1]);
            g.setColor(this.m_LineColor);
            g2d.setStroke(new BasicStroke(1.0f));
            g.drawLine(posX, posY, posX2, posY2);
        }
    }
}

