/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.rowset.serial.SerialException;

public class SerialRef
implements Ref,
Serializable,
Cloneable {
    private String baseTypeName;
    private Object object;
    private Ref reference;
    static final long serialVersionUID = -4727123500609662274L;

    public SerialRef(Ref ref) throws SerialException, SQLException {
        if (ref == null) {
            throw new SQLException("Cannot instantiate a SerialRef object with a null Ref object");
        }
        this.reference = ref;
        this.object = ref;
        if (ref.getBaseTypeName() == null) {
            throw new SQLException("Cannot instantiate a SerialRef object that returns a null base type name");
        }
        this.baseTypeName = new String(ref.getBaseTypeName());
    }

    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    public Object getObject(Map hashtable) throws SerialException {
        hashtable = new Hashtable(hashtable);
        if (!this.object.equals(null)) {
            return hashtable.get(this.object);
        }
        throw new SerialException("The object is not set");
    }

    public Object getObject() throws SerialException {
        if (this.reference != null) {
            try {
                return this.reference.getObject();
            }
            catch (SQLException sQLException) {
                throw new SerialException("SQLException: " + sQLException.getMessage());
            }
        }
        if (this.object != null) {
            return this.object;
        }
        throw new SerialException("The object is not set");
    }

    public void setObject(Object object) throws SerialException {
        try {
            this.reference.setObject(object);
        }
        catch (SQLException sQLException) {
            throw new SerialException("SQLException: " + sQLException.getMessage());
        }
        this.object = object;
    }
}

