/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ujmp.core.collections.AbstractDiskMap;
import org.ujmp.core.util.io.IntelligentFileReader;
import org.ujmp.core.util.io.IntelligentFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMap
extends AbstractDiskMap<String, String> {
    private static final long serialVersionUID = -7635770465612652548L;

    public TextMap() throws IOException {
        this((File)null, true);
    }

    public TextMap(String path) throws IOException {
        this(new File(path), true);
    }

    public TextMap(boolean useGZip) throws IOException {
        this((File)null, useGZip);
    }

    public TextMap(String path, boolean useGZip) throws IOException {
        this(new File(path), useGZip);
    }

    public TextMap(File path) throws IOException {
        this(path, true);
    }

    public TextMap(File path, boolean useGZip) throws IOException {
        super(path, useGZip);
    }

    @Override
    public final void writeValue(OutputStream os, String value) {
        IntelligentFileWriter.write(os, value);
    }

    @Override
    public String readValue(InputStream is) {
        String s = IntelligentFileReader.load(is);
        if (s != null && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

