/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.AdditionalInformationHandler;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.core.option.RecursiveOptionProducer;
import adams.doc.docbook.AbstractElement;
import adams.doc.docbook.Article;
import adams.doc.docbook.Document;
import adams.doc.docbook.InformalTable;
import adams.doc.docbook.Paragraph;
import adams.doc.docbook.Section;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class DocBookProducer
extends AbstractRecursiveOptionProducer<String, AbstractElement>
implements RecursiveOptionProducer,
FileBasedProducer {
    private static final long serialVersionUID = -1354998807180416601L;
    protected Document m_Document;
    protected boolean m_OutputDefaultValues;

    @Override
    public String globalInfo() {
        return "Generates comprehensive output in DocBook format, including the descriptions for the options and the default values.\n\nFor more information on the DocBook XML format, see:\nhttp://www.docbook.org/";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Document = new Document();
        this.m_OutputDefaultValues = false;
    }

    @Override
    protected String initOutput() {
        return "";
    }

    public void setOutputDefaultValues(boolean value) {
        this.m_OutputDefaultValues = value;
    }

    public boolean getOutputDefaultValues() {
        return this.m_OutputDefaultValues;
    }

    public String outputDefaultValuesTipText() {
        return "Whether to output or suppress default values.";
    }

    protected Section startSection(AbstractElement parent, Object obj) {
        Section result = new Section(obj.getClass().getName());
        parent.add(result);
        try {
            Method method = obj.getClass().getMethod("globalInfo", new Class[0]);
            if (method != null) {
                String globalInfo = (String)method.invoke(obj, new Object[0]);
                result.add(new Section("Synopsis", globalInfo));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (obj instanceof AdditionalInformationHandler) {
            result.add(new Section("Additional information", ((AdditionalInformationHandler)((Object)this.getInput())).getAdditionalInformation()));
        }
        return result;
    }

    protected void addDescription(AbstractElement parent, AbstractOption option) {
        String description;
        try {
            Method method = option.getToolTipMethod();
            description = (String)method.invoke((Object)option.getOptionHandler(), new Object[0]);
        }
        catch (Exception e) {
            description = "-no description-";
        }
        parent.add(new Paragraph(description));
    }

    @Override
    public AbstractElement processOption(BooleanOption option) {
        Section result = null;
        boolean different = ((Boolean)this.getCurrentValue(option)).equals((Boolean)option.getDefaultValue());
        if (this.m_OutputDefaultValues || different) {
            result = new Section(option.getProperty());
            this.addDescription(result, option);
            InformalTable table = new InformalTable(2);
            result.add(table);
            table.addRow(new String[]{"command-line flag", "-" + option.getCommandline()});
            table.addRow(new String[]{"value", "" + this.getCurrentValue(option)});
        }
        if (result != null) {
            ((AbstractElement)this.m_Nesting.peek()).add(result);
        }
        return result;
    }

    @Override
    public AbstractElement processOption(AbstractArgumentOption option) {
        Section result = null;
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result = new Section(option.getProperty());
            this.addDescription(result, option);
            InformalTable table = new InformalTable(2);
            result.add(table);
            table.addRow(new String[]{"command-line flag", "-" + option.getCommandline()});
            table.addRow(new String[]{"variable", option.getVariable()});
        } else {
            Object currValue = this.getCurrentValue(option);
            if (this.m_OutputDefaultValues || !this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    result = new Section(option.getProperty());
                    this.addDescription(result, option);
                    InformalTable table = new InformalTable(2);
                    result.add(table);
                    table.addRow(new String[]{"command-line flag", "-" + option.getCommandline()});
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        table.addRow(new String[]{"value", option.toString(Array.get(currValues, i))});
                    }
                }
            }
        }
        if (result != null) {
            ((AbstractElement)this.m_Nesting.peek()).add(result);
        }
        return result;
    }

    @Override
    public AbstractElement processOption(ClassOption option) {
        Section result = null;
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result = new Section(option.getProperty());
            this.addDescription(result, option);
            InformalTable table = new InformalTable(2);
            result.add(table);
            table.addRow(new String[]{"command-line flag", "-" + option.getCommandline()});
            table.addRow(new String[]{"variable", option.getVariable()});
        } else {
            Object currValue = this.getCurrentValue(option);
            if (this.m_OutputDefaultValues || !this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    result = new Section(option.getProperty());
                    this.addDescription(result, option);
                    InformalTable table = new InformalTable(2);
                    result.add(table);
                    table.addRow(new String[]{"command-line flag", "-" + option.getCommandline()});
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Section section;
                        Object value = Array.get(currValues, i);
                        Section nested = this.startSection(result, value);
                        this.m_Nesting.push(nested);
                        if (value instanceof OptionHandler) {
                            section = new Section("Options");
                            nested.add(section);
                            this.m_Nesting.push(section);
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                        } else {
                            AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                            section = new Section("Command-line");
                            nested.add(section);
                            table = new InformalTable(2);
                            section.add(table);
                            table.addRow(new String[]{"class", "" + value.getClass().getName()});
                            table.addRow(new String[]{"options", OptionUtils.joinOptions(handler.getOptions(value))});
                        }
                        this.m_Nesting.pop();
                    }
                }
            }
        }
        if (result != null) {
            ((AbstractElement)this.m_Nesting.peek()).add(result);
        }
        return result;
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Output = null;
        this.m_Document = new Document();
        this.m_Document.setRoot(new Article("Setup documentation"));
        this.startSection(this.m_Document.getRoot(), this.getInput());
        Section section = new Section("Options");
        this.m_Document.getRoot().add(section);
        this.m_Nesting.push(section);
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            StringBuilder buffer = new StringBuilder();
            this.m_Document.toXML(buffer);
            this.m_Output = buffer.toString();
        }
        return (String)this.m_Output;
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Document = null;
    }

    @Override
    public String getFileFormat() {
        return "DocBook";
    }

    @Override
    public String getDefaultFileExtension() {
        return "xml";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getDefaultFileExtension()};
    }
}

