/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.control.SequentialDirector;

public abstract class AbstractDirectedControlActor
extends AbstractControlActor {
    private static final long serialVersionUID = -7471817724012995179L;
    protected AbstractDirector m_Director;

    protected AbstractDirector newDirector() {
        return new SequentialDirector();
    }

    @Override
    protected String updateVariables() {
        if (this.m_Director != null) {
            this.m_Director.stopExecution();
            this.m_Director.cleanUp();
            this.m_Director = null;
        }
        return super.updateVariables();
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Director = this.newDirector();
            this.m_Director.setControlActor(this);
            this.m_Director.setDebugLevel(this.getDebugLevel());
            this.m_Director.updatePrefix();
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.addListener(this.m_Director);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            result = this.m_Director.execute();
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_Director != null) {
            while (!this.m_Director.isFinished()) {
                AbstractDirectedControlActor abstractDirectedControlActor = this;
                synchronized (abstractDirectedControlActor) {
                    try {
                        this.wait(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_Director != null) {
            this.m_PauseStateManager.removeListener(this.m_Director);
            this.m_Director.cleanUp();
            this.m_Director.setControlActor(null);
            this.m_Director = null;
        }
        super.cleanUp();
    }

    @Override
    public void stopExecution() {
        if (this.m_Director != null) {
            this.m_Director.stopExecution();
        }
        super.stopExecution();
    }
}

