/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.CleanUpHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public abstract class AbstractDisplay
extends AbstractActor {
    private static final long serialVersionUID = 8175993838879683118L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;
    protected int m_Width;
    protected int m_Height;
    protected int m_X;
    protected int m_Y;
    protected BasePanel m_Panel;
    protected BaseFrame m_Frame;
    protected Boolean m_Updating;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), 1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), 1, null);
        this.m_OptionManager.add("x", "x", this.getDefaultX(), -3, null);
        this.m_OptionManager.add("y", "y", this.getDefaultY(), -3, null);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("x");
        String result = "X:";
        result = variable != null ? variable : (this.m_X == -1 ? result + "left" : (this.m_X == -2 ? result + "center" : (this.m_X == -3 ? result + "right" : result + this.m_X)));
        variable = this.getOptionManager().getVariableForProperty("y");
        result = result + ", Y:";
        result = variable != null ? result + variable : (this.m_Y == -1 ? result + "top" : (this.m_Y == -2 ? result + "center" : (this.m_Y == -3 ? result + "bottom" : result + this.m_Y)));
        variable = this.getOptionManager().getVariableForProperty("width");
        result = result + ", W:";
        result = variable != null ? result + variable : result + this.m_Width;
        variable = this.getOptionManager().getVariableForProperty("height");
        result = result + ", H:";
        result = variable != null ? result + variable : result + this.m_Height;
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    public void input(Token token) {
        if (!this.m_Skip) {
            this.m_InputToken = token;
        }
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_InputToken = null;
    }

    protected int getDefaultX() {
        return -1;
    }

    protected int getDefaultY() {
        return -1;
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the dialog (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the dialog (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    @Override
    protected void reset() {
        super.reset();
        this.cleanUpGUI();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panel = null;
        this.m_Frame = null;
        this.m_Updating = false;
    }

    public abstract void clearPanel();

    protected abstract BasePanel newPanel();

    public BasePanel getPanel() {
        return this.m_Panel;
    }

    protected String createTitle() {
        return this.getFullName();
    }

    protected void preCreateFrame(BasePanel panel) {
    }

    protected BaseFrame doCreateFrame(BasePanel panel) {
        BaseFrame result = new BaseFrame(this.createTitle());
        int width = Math.min(GUIHelper.getScreenBounds((Window)result).width - this.m_X, this.getWidth());
        int height = Math.min(GUIHelper.getScreenBounds((Window)result).height - this.m_Y, this.getHeight());
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        result.setDefaultCloseOperation(1);
        result.setSize(width, height);
        ImageIcon icon = GUIHelper.getIcon(this.getClass());
        if (icon != null) {
            result.setIconImage(icon.getImage());
        } else {
            result.setIconImage(GUIHelper.getIcon("flow.gif").getImage());
        }
        if (panel instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)panel)).getMenuBar());
        } else if (this instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)this)).getMenuBar());
        }
        result.setLocation(ActorUtils.determineLocation(result, this.m_X, this.m_Y));
        return result;
    }

    protected void afterFrameShow(BaseFrame frame) {
    }

    protected void postCreateFrame(BaseFrame frame, BasePanel panel) {
    }

    protected BaseFrame createFrame(BasePanel panel) {
        this.preCreateFrame(panel);
        BaseFrame result = this.doCreateFrame(panel);
        this.postCreateFrame(result, panel);
        return result;
    }

    public BaseFrame getFrame() {
        return this.m_Frame;
    }

    protected abstract Runnable newDisplayRunnable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        if (!this.isHeadless()) {
            if (this.m_Panel == null) {
                this.m_Panel = this.newPanel();
                this.m_Frame = this.createFrame(this.m_Panel);
            }
            this.m_Updating = true;
            Runnable runnable = this.newDisplayRunnable();
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                SwingUtilities.invokeLater(runnable);
                try {
                    this.m_Self.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected void cleanUpGUI() {
        if (this.m_Frame != null) {
            if (this.m_Panel instanceof CleanUpHandler) {
                ((CleanUpHandler)((Object)this.m_Panel)).cleanUp();
            }
            this.m_Frame.setVisible(false);
            this.m_Frame.dispose();
            this.m_Frame = null;
            this.m_Panel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        try {
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                this.m_Self.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractDisplay.this.cleanUpGUI();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

